/*
 * QueryConnectionFactory class.
 *
 * Copyright (C) 2011 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.query;

import ts.util.ReasonedException;

/**
 * クエリ・コネクション・オブジェクトを作成するためのファクトリ・クラスの
 * インターフェイス。
 * <br>
 * 初期設定オブジェクトを引数にとってクエリ・コネクション・オブジェクトを
 * 作成する{@link #create(String, QueryConfig)}メソッドを宣言している。
 *
 * @author 佐藤隆之
 * @version $Id: QueryConnectionFactory.java,v 1.2 2011-07-27 14:38:14 tayu Exp $
 */
public interface QueryConnectionFactory
{
  /** このクラスから発生しうるエラーの列挙型。 */
  public enum Error {
    /** コネクション・オブジェクトの作成に失敗したことを示す列挙値。 */
    FailToCreate,
  }

  /**
   * 初期設定オブジェクトを使ってクエリ・コネクション・オブジェクトを作成
   * する。
   *
   * @param connId コネクションを識別するためのID。
   * @param config 初期設定オブジェクト。
   * @return クエリ・コネクション・オブジェクト。
   * @throws ReasonedException コネクション・オブジェクトの作成に失敗した
   *   場合。
   */
  QueryConnection create(String connId, QueryConfig config)
    throws ReasonedException;
}
