package ts.query;

import ts.tester.UnitTest;
import ts.util.table.*;
import ts.util.*;

public class QueryResultTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryResultTest.class, args);
  }

  public void constructor_context()
  {
    MSG("コンテキスト・オブジェクトを引数にとるコンストラクタ。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());
  }

  public void constructor_context_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void setSuccess_boolean()
  {
    MSG("クエリの成否フラグを設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setSuccess(true);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    TRUE (rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setSuccess(false);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());
  }

  public void setResultCount_int()
  {
    MSG("処理件数を設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setResultCount(1);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 1);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setResultCount(123);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 123);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setResultCount(0);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());
  }

  public void setResultCount_int_Negative()
  {
    MSG("引数が負値の場合。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    try {
      rslt.setResultCount(-1);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void setSpentTimeMillis_long()
  {
    MSG("処理時間を設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setSpentTimeMillis(1L);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 1L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setSpentTimeMillis(123456L);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 123456L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    rslt.setSpentTimeMillis(0L);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());
  }

  public void setSpentTimeMillis_long_Negative()
  {
    MSG("引数が負値の場合。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);

    try {
      rslt.setSpentTimeMillis(-1L);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  enum Error {
    Error0, Error1
  }

  public void setException_ReasonedException()
  {
    MSG("実行失敗の例外オブジェクトを設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    ReasonedException exc0 = new ReasonedException(Error.Error0);
    rslt.setException(exc0);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    EQUAL(rslt.getException(), exc0);
    EQUAL(rslt.getExceptionReason(), Error.Error0);
    NULL(rslt.getResultTable());

    ReasonedException exc1 = new ReasonedException(Error.Error1);
    rslt.setException(exc1);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    EQUAL(rslt.getException(), exc1);
    EQUAL(rslt.getExceptionReason(), Error.Error1);
    NULL(rslt.getResultTable());

    rslt.setException((ReasonedException) null);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());
  }

  public void setException_ReasonedRuntimeException()
  {
    MSG("実行失敗のランタイム例外オブジェクトを設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());

    ReasonedRuntimeException exc0 = new ReasonedRuntimeException(Error.Error0);
    rslt.setException(exc0);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    EQUAL(rslt.getException(), exc0);
    EQUAL(rslt.getExceptionReason(), Error.Error0);
    NULL(rslt.getResultTable());

    ReasonedRuntimeException exc1 = new ReasonedRuntimeException(Error.Error1);
    rslt.setException(exc1);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    EQUAL(rslt.getException(), exc1);
    EQUAL(rslt.getExceptionReason(), Error.Error1);
    NULL(rslt.getResultTable());

    rslt.setException((ReasonedRuntimeException) null);
    EQUAL(rslt.getQueryId(), "q0");
    EQUAL(rslt.getContext(), ctx);
    FALSE(rslt.isSuccess());
    EQUAL(rslt.getResultCount(), 0);
    EQUAL(rslt.getSpentTimeMillis(), 0L);
    NULL(rslt.getException());
    NULL(rslt.getExceptionReason());
    NULL(rslt.getResultTable());
  }

  public void setResultTable_table()
  {
    MSG("結果テーブルを設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    QueryResult rslt = new QueryResult(ctx);
    NULL(rslt.getResultTable());

    Table<String,Object> table0 = new ArrayListTable<String,Object>();
    rslt.setResultTable(table0);
    EQUAL(rslt.getResultTable(), table0);

    Table<String,Object> table1 = new MapListTable<String,Object>();
    rslt.setResultTable(table1);
    EQUAL(rslt.getResultTable(), table1);

    rslt.setResultTable(null);
    NULL(rslt.getResultTable());
  }
}

