/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.List;
import java.util.Map;
import ts.query.Query;
import ts.query.QueryConnection;
import ts.query.QueryContent;
import ts.query.QueryOutput;
import ts.query.QueryResource;
import ts.query.QueryResult;
import ts.query.QueryResultList;
import ts.util.ReasonedException;
import ts.util.table.ArrayListTable;
import ts.util.table.Header;
import ts.util.table.Table;

public class DefaultQuery
implements Query {
    private final QueryConnection connection;
    private final QueryResource resource;

    public DefaultQuery(QueryConnection queryConnection, QueryResource queryResource) {
        assert (queryConnection != null && queryResource != null) : queryConnection == null ? "@param:conn is null." : (queryResource == null ? "@param:res is null." : "");
        this.connection = queryConnection;
        this.resource = queryResource;
    }

    protected QueryConnection getConnection() {
        return this.connection;
    }

    protected QueryResource getResource() {
        return this.resource;
    }

    @Override
    public QueryResult execute(String string, Map<String, Object> map) throws ReasonedException {
        return this.executeQuery(string, map, null);
    }

    @Override
    public QueryResultList executeSet(String[] stringArray, Map<String, Object> map) throws ReasonedException {
        assert (stringArray != null && map != null) : stringArray == null ? "@param:qidArr is null." : (map == null ? "@param:inputMap is null." : "");
        long l = System.currentTimeMillis();
        QueryResultList queryResultList = new QueryResultList();
        for (String string : stringArray) {
            QueryResult queryResult = this.executeQuery(string, map, queryResultList);
            queryResultList.addResult(queryResult);
        }
        long l2 = System.currentTimeMillis();
        queryResultList.setSpentTimeMillis(l2 - l);
        return queryResultList;
    }

    @Override
    public QueryResultList executeSet(List<String> list, Map<String, Object> map) throws ReasonedException {
        assert (list != null && map != null) : list == null ? "@param:qidLst is null." : (map == null ? "@param:inputMap is null." : "");
        long l = System.currentTimeMillis();
        QueryResultList queryResultList = new QueryResultList();
        for (String string : list) {
            QueryResult queryResult = this.executeQuery(string, map, queryResultList);
            queryResultList.addResult(queryResult);
        }
        long l2 = System.currentTimeMillis();
        queryResultList.setSpentTimeMillis(l2 - l);
        return queryResultList;
    }

    @Override
    public QueryResultList executeAll(Map<String, Object> map) throws ReasonedException {
        assert (map != null) : "@param:inputMap is null.";
        long l = System.currentTimeMillis();
        QueryResultList queryResultList = new QueryResultList();
        for (String string : this.getResource().listAllQueryIds()) {
            QueryResult queryResult = this.executeQuery(string, map, queryResultList);
            queryResultList.addResult(queryResult);
        }
        long l2 = System.currentTimeMillis();
        queryResultList.setSpentTimeMillis(l2 - l);
        return queryResultList;
    }

    protected Table<String, Object> newResultTable(QueryContent queryContent) {
        assert (queryContent != null) : "@param:cont is null.";
        ArrayListTable.Header header = new ArrayListTable.Header(queryContent.countOutputs());
        for (QueryOutput queryOutput : queryContent.getOutputs()) {
            header.addColumn((Object)queryOutput.getName());
        }
        return new ArrayListTable((Header)header);
    }

    protected QueryResult executeQuery(String string, Map<String, Object> map, QueryResultList queryResultList) throws ReasonedException {
        assert (string != null && map != null) : string == null ? "@param:query is null." : (map == null ? "@param:inputMap is null." : "");
        long l = System.currentTimeMillis();
        QueryResult queryResult = new QueryResult(this.getConnection().getId(), string);
        try {
            this.checkTimeout(string);
            QueryContent queryContent = this.getResource().createContent(string, map, queryResultList);
            queryResult.setContent(queryContent);
            this.checkTimeout(string);
            if (queryContent.hasResultTable()) {
                Table<String, Object> table = this.newResultTable(queryContent);
                int n = this.getConnection().executeContent(queryContent, table);
                queryResult.setResultTable(table);
                queryResult.setResultCount(n);
            } else {
                int n = this.getConnection().executeContent(queryContent);
                queryResult.setResultCount(n);
            }
            queryResult.setSuccess(true);
        }
        catch (Exception exception) {
            queryResult.setSuccess(false);
            queryResult.setException(exception);
            throw queryResult.getReasonedException();
        }
        finally {
            long l2 = System.currentTimeMillis();
            queryResult.setSpentTimeMillis(l2 - l);
            this.getConnection().getTransactionQueryResultList().addResult(queryResult);
        }
        return queryResult;
    }

    protected void checkTimeout(String string) throws ReasonedException {
        QueryConnection queryConnection = this.getConnection();
        long l = queryConnection.getLimitTimeMillis();
        if (l > 0L && l < System.currentTimeMillis()) {
            throw new ReasonedException((Enum)Query.Error.Timeout, "[connection:" + queryConnection.getId() + "][query:" + string + "]");
        }
    }
}

