/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function.print;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import ts.tester.coverage.Coverage;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.LineCoverage;
import ts.tester.coverage.PassResult;
import ts.tester.coverage.Result;
import ts.tester.function.print.ConsolePrinterBase;

public class ConsolePrinter
extends ConsolePrinterBase
implements CoveragePrinter {
    private List<String> sourcePathLst_ = new LinkedList<String>();

    public ConsolePrinter() {
    }

    public ConsolePrinter(PrintWriter printWriter) {
        super(printWriter);
    }

    @Override
    public void prepareCoverage(Coverage coverage) {
    }

    @Override
    public void postCoverage(Coverage coverage) {
        assert (coverage != null) : "@param:coverage is null.";
        if (coverage instanceof LineCoverage) {
            this.printLineCoverage((LineCoverage)coverage);
        }
    }

    @Override
    public void entryClass(ReferenceType referenceType) {
        assert (referenceType != null) : "@param:refType is null.";
        try {
            List<String> list = referenceType.sourcePaths(null);
            for (String string : list) {
                if (this.sourcePathLst_.contains(string)) continue;
                this.sourcePathLst_.add(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void entryLine(Location location) {
    }

    @Override
    public void entryMethod(Method method) {
    }

    @Override
    public void exitMethod(Method method) {
    }

    @Override
    public void passLine(Location location) {
    }

    protected void printLineCoverage(LineCoverage lineCoverage) {
        this.writer().println();
        this.writer().println("Coverage ==>");
        for (String string : this.sourcePathLst_) {
            PassResult<Integer> passResult = lineCoverage.getPassResult(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" + ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(passResult.passedRatio() * 100.0f);
            stringBuffer.append("% (");
            stringBuffer.append(((Result)passResult).countPassedResults());
            stringBuffer.append(" / ");
            stringBuffer.append(((Result)passResult).countAllResults());
            stringBuffer.append(" lines)");
            this.writer().println(stringBuffer.toString());
            if (!(passResult.passedRatio() < 1.0f)) continue;
            stringBuffer = new StringBuffer();
            stringBuffer.append("   {");
            Enumeration enumeration = ((Result)passResult).enumNotPassedResultKeys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (((Result)passResult).getPassCountOfResult(n) != 0) continue;
                stringBuffer.append(" ").append(n);
            }
            stringBuffer.append(" }");
            this.writer().println(stringBuffer.toString());
        }
        this.writer().flush();
    }
}

