/*
 * DefaultResource class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import java.util.List;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import ts.util.text.StringOperation;

/**
 * Kw\vfł{@link ts.util.resource.Element Element}
 * IuWFNggă\[Xf[^Ǘ郊\[XNXB
 * <br>
 * {Kw\Ȃf[^\[XIuWFNgňƂł悤
 * 邽߂ɗpӂꂽۃNXłB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2011-08-01 15:29:31 $
 */
public abstract class DefaultResource extends AbstractResource
{
  /** [gvfB */
  private Element rootElement_ ;

  /** vfB */
  private Element baseElement_ ;

  /**
   * ftHgRXgN^B
   */
  public DefaultResource()
  {
    rootElement_ = Element.createRootElement();
    baseElement_ = rootElement_ ;
  }

  /**
   * Rs[RXgN^B
   *
   * @param  res Rs[̃\[XIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public DefaultResource(DefaultResource res)
  {
    super(res);

    rootElement_ = res.getRootElement();
    baseElement_ = res.getBaseElement();
  }

  /**
   * ̃IuWFNgďB
   */
  protected void renew()
  {
    rootElement_ = Element.createRootElement();
    baseElement_ = rootElement_ ;
  }

  /**
   * [gvf擾B
   *
   * @return [gvfIuWFNgB
   */
  protected Element getRootElement()
  {
    return rootElement_ ;
  }

  /**
   * vf擾B
   *
   * @return vfIuWFNgB
   */
  protected Element getBaseElement()
  {
    return baseElement_ ;
  }

  /**
   * vf̖O擾B
   *
   * @return vf̖OB
   */
  public String getBaseElementName()
  {
    return getBaseElement().getName();
  }

  /**
   * ̃IuWFNgƓNX̃\[XIuWFNg쐬B
   *
   * @return ̃IuWFNgƓNX̃\[XIuWFNgB
   */
  protected abstract DefaultResource createResource();

  /**
   * w肳ꂽL[ɍŏɊYvf擾B
   * <br>
   * YvfM݂Ȃꍇ̓kԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɑΉvfB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected Element findFirstElement(String key) throws IllegalKeyException
  {
    assert (key != null) : "@param:key is null.";

    if (StringOperation.isEmpty(key)) {
      return getBaseElement();
    }

    return findFirstElement(getBaseElement(), splitKey(key), 0);
  }

  /**
   * L[vfXgɍŏɊY鉺ʗvfċAIɒTB
   *
   * @param  elem vfB
   * @param  keyElemLst L[vfXgB
   * @param  index ݒT̃L[vf̃CfbNXB
   * @return L[vfXgɊYvfB
   * @throws NullPointerException k̏ꍇB
   * @throws IndexOutOfBoundsException L[vf̃CfbNX̒l̏ꍇB
   */
  private Element findFirstElement(
    Element elem, List<String> keyElemLst, int index
  ) throws NullPointerException, IndexOutOfBoundsException
  {
    if (index >= keyElemLst.size()) {
      return elem;
    }

    String keyElem = keyElemLst.get(index);
    String elemName = getNameOfKeyElement(keyElem);
    List<String[]> attrLst = listAttributesOfKeyElement(keyElem);

    List<Element> eL = elemName.equals("*") ? 
      elem.getAllChildren() : elem.getChildren(elemName);

    NEXT_ELEM:
    for (Element e : eL) {
      AttributeMap attrMap = e.getAttributes();
      for (String[] attr : attrLst) {
        if (! attr[1].equals(attrMap.get(attr[0]))) {
          continue NEXT_ELEM;
        }
      }

      Element child = findFirstElement(e, keyElemLst, index + 1);
      if (child != null) {
        return child;
      }
    }

    return null;
  }

  /**
   * w肳ꂽL[ɊYSĂ̗vf擾B
   * <br>
   * Yvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɑΉSĂ̗vfi[郊XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected List<Element> findAllElements(String key) throws IllegalKeyException
  {
    assert (key != null) : "@param:key is null.";

    List<Element> elemLst = new LinkedList<Element>();

    if (StringOperation.isEmpty(key)) {
      elemLst.add(getBaseElement());
      return elemLst;
    }

    List<String> keyElemLst = splitKey(key);
    findAllElements(elemLst, getBaseElement(), keyElemLst, 0);
    return elemLst;
  }

  /**
   * L[vfXgɊYSẲʗvfċAIɒTāAXgɊi[
   * B
   *
   * @param  elemLst Yvfi[郊XgB
   * @param  elem vfB
   * @param  keyElemLst L[vfXgB
   * @param  index ݒT̃L[vf̃CfbNXB
   * @throws NullPointerException k̏ꍇB
   * @throws IndexOutOfBoundsException CfbNX̒l̏ꍇB
   */
  private void findAllElements(
    List<Element> elemLst, Element elem, List<String> keyElemLst, int index
  ) throws NullPointerException, IndexOutOfBoundsException
  {
    if (index >= keyElemLst.size()) {
      elemLst.add(elem);
      return;
    }

    String keyElem = keyElemLst.get(index);
    String elemName = getNameOfKeyElement(keyElem);
    List<String[]> attrLst = listAttributesOfKeyElement(keyElem);

    List<Element> eL = elemName.equals("*") ? 
      elem.getAllChildren() : elem.getChildren(elemName);

    NEXT_ELEM:
    for (Element e : eL) {
      if (attrLst.size() > 0) {
        AttributeMap attrMap = e.getAttributes();
        for (String[] attr : attrLst) {
          if (! attr[1].equals(attrMap.get(attr[0]))) {
            continue NEXT_ELEM;
          }
        }
      }

      findAllElements(elemLst, e, keyElemLst, index + 1);
    }
  }

  /**
   * ̃L[ɍŏɊY鉺ʗvfTāA݂΂ԂA
   * ݂Ȃ΍쐬ĕԂB
   * <br>
   * ̃L[sȏꍇ́AOX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɑΉA͍쐬ꂽvfB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected Element findOrCreateFirstElement(String key)
    throws IllegalKeyException
  {
    assert (key != null) : "@param:key is null.";

    if (StringOperation.isEmpty(key)) {
      return getBaseElement();
    }

    return findOrCreateFirstElement(splitKey(key));
  }

  /**
   * L[vfXgɍŏɊY鉺ʗvfTāA݂΂ԂA
   * ݂Ȃ΍쐬ĕԂB
   *
   * @param  keyElemLst L[vfXgB
   * @return ̃L[ɍŏɑΉA͍쐬ꂽvfB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected Element findOrCreateFirstElement(List<String> keyElemLst)
  {
    assert (keyElemLst != null) : "@param:keyElemLst is null.";

    Element elem = getBaseElement();
    List<String> singleKeyL = new ArrayList<String>(1);
    singleKeyL.add("");
    int i = 0;
    for (; i<keyElemLst.size(); i++) {
      singleKeyL.set(0, keyElemLst.get(i));
      Element e = findFirstElement(elem, singleKeyL, 0);
      if (e == null) {
        break;
      }
      elem = e;
    }

    for (; i<keyElemLst.size(); i++) {
      String keyElem = keyElemLst.get(i);
      String elemName = getNameOfKeyElement(keyElem);
      List<String[]> attrLst = listAttributesOfKeyElement(keyElem);

      Element newElem = new Element(elemName);
      for (String[] attr : attrLst) {
        newElem.putAttribute(attr[0], attr[1]);
      }
      elem.addChild(newElem);
      elem = newElem;
    }

    return elem;
  }

  /**
   * w肳ꂽL[ɍŏɊYvf̒l擾B
   * <br>
   * Yvf݂Ȃꍇ͋󕶎ԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɊYvf̒lB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized String getFirstValue(String key)
    throws IllegalKeyException
  {
    Element e = findFirstElement(key);
    if (e == null) {
      return "";
    }

    String s = e.getValue();
    return (s != null) ? s : "";
  }

  /**
   * w肳ꂽL[ɊYSvf̒l̃Xg擾B
   * <br>
   * Yvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɊYSvf̒l̃XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError ̃k̏ꍇifobO[ĥ݁jB
   */
  public synchronized List<String> getValues(String key)
    throws IllegalKeyException
  {
    List<Element> elemLst = findAllElements(key);

    List<String> valueLst = new ArrayList<String>(elemLst.size());
    for (Element elem : elemLst) {
      String s = elem.getValue();
      valueLst.add((s != null) ? s : "");
    }

    return valueLst;
  }

  /**
   * w肳ꂽL[ɍŏɊYvf́Aw肳ꂽ̒l擾B
   * <br>
   * Yvf݂Ȃꍇ͋󕶎ԂB
   * YvfɁAw肳ꂽȎ݂Ȃꍇ͋󕶎ԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @param  attr B
   * @return ̃L[ɍŏɊYvf́Aw肳ꂽ̒lB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertError k̏ꍇB
   */
  public synchronized String getFirstAttribute(String key, String attr)
    throws IllegalKeyException
  {
    assert (attr != null) : "@param:attr is null.";

    Element elem = findFirstElement(key);
    if (elem == null) {
      return "";
    }

    Map<String, String> attrMap = elem.getAttributes();

    String v = attrMap.get(attr);
    if (v == null) {
      return "";
    }

    return v;
  }

  /**
   * w肳ꂽL[ɊYSvf́Aw肳ꂽ̒l̃Xg擾B
   * <br>
   * Yvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @param  attr B
   * @return ̃L[ɊYSvf́Aw肳ꂽ̒l̃XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertError k̏ꍇB
   */
  public synchronized List<String> getAttributes(String key, String attr)
    throws IllegalKeyException
  {
    assert (attr != null) : "@param:attr is null.";

    List<Element> elemLst = findAllElements(key);

    List<String> valueLst = new ArrayList<String>(elemLst.size());
    for (Element elem : elemLst) {
      AttributeMap attrMap = elem.getAttributes();
      String v = attrMap.get(attr);
      valueLst.add((v != null) ? v : "");
    }

    return valueLst;
  }

  /**
   * w肳ꂽL[ɍŏɊYvfvfƂq\[X擾B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ
   * {@link ts.util.resource.Resource#EMPTY}ԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɊYvf̎q\[XB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized Resource getFirstChild(String key)
    throws IllegalKeyException
  {
    Element elem = findFirstElement(key);
    if (elem == null) {
      return Resource.EMPTY;
    }

    DefaultResource res = createResource();
    res.baseElement_ = elem;
    return res;
  }

  /**
   * w肳ꂽL[ɍŏɊYq\[X̃Xg擾B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɊYvf̎q\[X̃XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized List<Resource> getChildren(String key)
    throws IllegalKeyException
  {
    List<Element> elemLst = findAllElements(key);

    List<Resource> resLst = new ArrayList<Resource>(elemLst.size());
    for (Element e : elemLst) {
      DefaultResource res = createResource();
      res.baseElement_ = e;
      resLst.add(res);
    }

    return resLst;
  }

  /**
   * w肳ꂽL[ɍŏɊYvfɁAlݒ肷B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ́A̗vf쐬
   * lݒ肷B
   *
   * @param  key L[B
   * @param  value ̃L[ɍŏɊYvfɐݒ肷lB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized void setFirstValue(String key, String value)
    throws IllegalKeyException
  {
    assert (value != null) : "@param:value is null.";

    try {
      Element elem = findOrCreateFirstElement(key);
      if (elem == getRootElement()) {
        throw new IllegalKeyException(key);
      }
      elem.setValue(value);
    }
    catch (IllegalKeyException e) {
      throw e;
    }
    catch (Exception e) {
      throw new IllegalKeyException(key, e);
    }
  }

  /**
   * w肳ꂽL[ɍŏɊYvfvfƂq\[X擾B
   * w肳ꂽL[ɊYvf݂Ȃꍇ͍쐬ĕԂB
   * <br>
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return w肳ꂽL[ɍŏɊYvfvfƂq\[XB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized Resource getOrCreateFirstChild(String key)
    throws IllegalKeyException
  {
    try {
      Element elem = findOrCreateFirstElement(key);

      DefaultResource res = createResource();
      res.baseElement_ = elem;
      return res;
    }
    catch (IllegalKeyException e) {
      throw e;
    }
  }

  /**
   * w肳ꂽL[ɊYSĂ̗vf폜B
   * <br>
   * w肳ꂽL[ɊYvfȂꍇ́AȂB
   *
   * @param  key L[B
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized void removeChildren(String key) throws IllegalKeyException
  {
    List<Element> elemLst = findAllElements(key);
    for (Element elem : elemLst) {
      Element parent = elem.getParent();
      if (parent != null) {
        parent.removeChildren(elem.getName());
      }
      else {
        renew();
      }
    }
  }
}
