/*
 * Index class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import ts.util.IdentityHashSet;
import java.io.Serializable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Collections;
import java.util.NoSuchElementException;

/**
 * CfbNXENXB
 * <br>
 * w肳ꂽJ̒lgăR[h̃CfbNX쐬AR[ȟ
 * }B
 * <br>
 * CfbNXɎgpJ͕w肷邱ƂłB
 * <br>
 * <br>
 * ̃NX́A{@link ts.util.table.Table Table}CvgĂA
 * e[uEIuWFNgƓlɃR[h̒ǉEE폜EXV̑s
 * ƂłB
 * <br>
 * ̃CfbNXɑ΂ăR[h̒ǉE폜EXVsƁA쐬̃e[u
 * ɂ̕ύXfB
 * ΂ɁA쐬̃e[uɑ΂ăR[h̒ǉE폜EXVsƂA
 * ̃CfbNXɂ̕ύXfB
 *
 * @author  V.
 * @version $Revision: 1.3 $, $Date: 2011-10-29 14:52:05 $
 */
public abstract class Index<C,V> implements Table<C,V>
{
  /** CfbNXEL[̔zB */
  private C[] indexKeys_ ;

  /** CfbNXEc[̃[gEm[hE}bvB */
  private IndexNodeMap rootMap_ = new IndexNodeMap();

  /**
   * CfbNXEL[ƂȂJ̔zɂƂRXgN^B
   *
   * @param  indexKeys CfbNXEL[̔zB
   * @throws IllegalArgumentException ̔z̃TCY[̏ꍇB
   * @throws AssertionError k̏ꍇB
   */
  protected Index(C[] indexKeys)
  {
    assert (indexKeys != null) : "@param:indexKeys is null.";

    if (indexKeys.length == 0) {
      throw new IllegalArgumentException("@param:indexKeys is an empty array.");
    }
    indexKeys_ = indexKeys;
  }

  /**
   * ̃CfbNX̍쐬łe[uEIuWFNg擾B
   *
   * @return 쐬̃e[uEIuWFNgB
   */
  protected abstract Table<C,V> getBaseTable();

  /**
   * 쐬̃e[uɊi[ĂJ̐擾B
   *
   * @return JB
   */
  public int columnCount()
  {
    return getBaseTable().columnCount();
  }

  /**
   * 쐬̃e[uɊi[Ă郌R[h̐擾B
   *
   * @return R[hB
   */
  public int recordCount()
  {
    return getBaseTable().recordCount();
  }

  /**
   * CfbNXEL[̐擾B
   *
   * @return CfbNXEL[̐B
   */
  protected int indexKeyCount()
  {
    return indexKeys_.length;
  }

  /**
   * 쐬̃e[u\JEL[񋓂B
   *
   * @return JEL[̗񋓃IuWFNgB
   */
  public Enumeration<C> columns()
  {
    return getBaseTable().columns();
  }

  /**
   * 쐬̃e[uɊi[Ă郌R[hɎo߂̃Ce[^
   * 擾B
   *
   * @return R[h̃Ce[^B
   */
  public MapIterator<C,V> records()
  {
    return getBaseTable().records();
  }

  /**
   * 쐬̃e[uɊi[Ă郌R[h\[gāAɎo߂
   * Ce[^擾B
   *
   * @param  comparator \[gɎgp郌R[hrIuWFNgB
   * @return R[h̃Ce[^B
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public MapIterator<C,V> records(MapComparator<C,V> comparator)
  {
    return getBaseTable().records(comparator);
  }

  /**
   * 쐬̃e[uɍŏɊi[Ă郌R[h擾B
   *
   * @return 쐬̃e[uɍŏɊi[Ă郌R[hB
   */
  public Map<C,V> recordFirst()
  {
    return getBaseTable().recordFirst();
  }

  /**
   * CfbNXEL[񋓂B
   *
   * @return CfbNXEL[̗񋓃IuWFNgB
   */
  protected Enumeration<C> indexKeys()
  {
    return new Enumeration<C>() {
      private int ind_ = 0;
      public boolean hasMoreElements() {
        return (ind_ < indexKeys_.length);
      }
      public C nextElement() {
        try {
          C c = indexKeys_[ind_];
          ind_ ++;
          return c;
        }
        catch (Exception e) {
          throw new NoSuchElementException();
        }
      }
    };
  }

  /**
   * w肳ꂽz̗vfCfbNXEL[ƂCfbNX擾B
   * <br>
   * YCfbNX݂Ȃꍇ́ACfbNX쐬ĕԂB
   *
   * @param  indexKeys CfbNXEL[̔zB
   * @return ̃e[ũCfbNXEIuWFNgB
   */
  public Index<C,V> getIndex(C ... indexKeys)
  {
    return getBaseTable().getIndex(indexKeys);
  }

  /**
   * 쐬̃e[uɃgKǉB
   *
   * @param  trigger gKEIuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void addTrigger(Trigger<C,V> trigger)
  {
    getBaseTable().addTrigger(trigger);
  }

  /**
   * SẴR[h폜B
   */
  public void deleteAll()
  {
    getBaseTable().deleteAll();
  }

  /**
   * VR[h쐬āA쐬̃e[uɒǉB
   * <br>
   * ǉꂽR[h́A}bvEIuWFNg̖߂lƂĕԂB
   *
   * @return ǉꂽR[h\}bvEIuWFNgB
   */
  public Map<C,V> appendNew()
  {
    return getBaseTable().appendNew();
  }

  /**
   * VR[h쐬āA쐬̃e[uɒǉB
   * <br>
   * ǉꂽR[h́A}bvEIuWFNg̖߂lƂĕԂB
   *
   * @param  initColCapacity R[h̏JeʁB
   * @return ǉꂽR[h\}bvEIuWFNgB
   * @throws AssertionError ̒l̏ꍇifobOE[ĥ݁jB
   */
  public Map<C,V> appendNew(int initColCapacity)
  {
    return getBaseTable().appendNew(initColCapacity);
  }

  /**
   * {@inheritDoc}
   */
  public boolean exists(C column, V value)
  {
    Map<C,V> condition = new HashMap<C,V>();
    condition.put(column, value);
    return exists(condition);
  }

  /**
   * {@inheritDoc}
   */
  public Map<C,V> selectFirst(C column, V value)
  {
    Map<C,V> condition = new HashMap<C,V>();
    condition.put(column, value);
    return selectFirst(condition);
  }

  /**
   * {@inheritDoc}
   */
  public List<Map<C,V>> select(C column, V value)
  {
    Map<C,V> condition = new HashMap<C,V>();
    condition.put(column, value);
    return select(condition);
  }

  /**
   * ̃CfbNX̃L[ɂāAɊY郌R[h̃RNV
   * 擾B
   * <br>
   * Y郌R[hPȂꍇ͋̃RNVԂB
   *
   * @param  condition ̃JƂ̒li[}bvB
   * @return ̃CfbNX̃L[ɂďɊY郌R[h
   *         RNVB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  protected Collection<Record<C,V>> collectRecords(Map<C,V> condition)
  {
    assert (condition != null) : "@param:condition is null.";
    return collectRecords(rootMap_, 0, condition);
  }

  /**
   * ̃CfbNX̃L[ɂďɊY郌R[h̃RNV
   * ċAIɒTĎ擾B
   * <br>
   * Y郌R[h1Ȃꍇ͋̃RNVԂB
   *
   * @param  indexMap T̃CfbNXE}bvB
   * @param  keyind TΏۂ̃CfbNXEL[̔zʒuB
   * @param  condition ̃JƂ̒li[}bvEIuWFNgB
   * @return ̃CfbNX̃L[ɂďɊY郌R[h
   *         RNVB
   */
  private Collection<Record<C,V>> collectRecords(
    IndexNodeMap indexMap, int keyind, Map<C,V> condition)
  {
    C key = indexKeys_[keyind];
    V val = condition.get(key);
    keyind ++;

    if (val == null && !condition.containsKey(key)) {
      RecordSet set = new RecordSet();
      for (Object o : indexMap.values()) {
        if (o instanceof HashMap) {
          set.addAll(collectRecords((IndexNodeMap) o, keyind, condition));
        }
        else if (o instanceof IdentityHashSet) {
          set.addAll((RecordSet) o);
        }
      }
      return set;
    }
    else {
      Object o = indexMap.get(val);
      if (o != null) {
        if (o instanceof HashMap) {
          return collectRecords((IndexNodeMap) o, keyind, condition);
        }
        else if (o instanceof IdentityHashSet) {
          return (RecordSet) o;
        }
      }
      return new RecordSet();
    }
  }

  /**
   * w肳ꂽR[hi[ACfbNXEc[̖[ɐݒ肳Ă
   * RNVEIuWFNg擾B
   * <br>
   * w肳ꂽR[hi[RNVEIuWFNg݂Ȃꍇ́A
   * ̃RNVEIuWFNgԂB
   *
   * @param  record R[hEIuWFNgB
   * @return ̃R[hEIuWFNgi[RNVEIuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  protected Collection<Record<C,V>> getIndexedCollection(Record<C,V> record)
  {
    assert (record != null) : "@param:record is null.";

    IndexNodeMap map = rootMap_ ;

    for (int i=0; i<indexKeys_.length-1; i++) {
      Object obj = map.get(record.get(indexKeys_[i]));
      if (obj != null && (obj instanceof HashMap)) {
        map = (IndexNodeMap) obj;
      }
      else {
        return new RecordSet();
      }
    }

    Object last = map.get(record.get(indexKeys_[indexKeys_.length-1]));
    if (last != null && (last instanceof IdentityHashSet)) {
      return (RecordSet) last;
    }
    else {
      return new RecordSet();
    }
  }

  /**
   * w肳ꂽR[hi[ACfbNXEc[̖[ɐݒ肳Ă
   * RNVEIuWFNg擾B
   * <br>
   * w肳ꂽR[hi[RNVEIuWFNg݂Ȃꍇ́A
   * ̃RNVEIuWFNg쐬ĕԂB
   *
   * @param  record R[hEIuWFNgB
   * @return ̃R[hEIuWFNgi[RNVEIuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  protected Collection<Record<C,V>> getIndexedCollectionByForce(
    Record<C,V> record)
  {
    assert (record != null) : "@param:record is null.";

    IndexNodeMap map = rootMap_ ;

    for (int i=0; i<indexKeys_.length-1; i++) {
      V val = record.get(indexKeys_[i]);
      Object obj = map.get(val);
      if (obj != null && (obj instanceof HashMap)) {
        map = (IndexNodeMap) obj;
      }
      else {
        IndexNodeMap m = new IndexNodeMap();
        map.put(val, m);
        map = m;
      }
    }

    RecordSet set;
    V lastVal = record.get(indexKeys_[indexKeys_.length - 1]);
    Object lastObj = map.get(lastVal);
    if (lastObj != null && (lastObj instanceof IdentityHashSet)) {
      set = (RecordSet) lastObj;
    }
    else {
      set = new RecordSet();
      map.put(lastVal, set);
    }
    set.add(record);
    return set;
  }

  /**
   * ̃CfbNXSẴR[h폜B
   */
  protected void deleteAllRecordsFromIndex()
  {
    rootMap_.clear();
  }


  /* -- inner class -- */

  /**
   * CfbNXEc[\}bvENXB
   */
  protected class IndexNodeMap extends HashMap<V,Object>
  {
    /** VAEo[WԍB */
    static final long serialVersionUID = 8037487212928327L;
  }

  /**
   * R[hi[ZbgENXB
   * <br>
   * CfbNXEc[̖[ɔzuACfbNXEL[̒lR[h
   * ̏Wi[B
   * <br>
   * ̃NX́A{@link ts.util.IdentityHashSet IdentityHashSet}
   * ĂAɃR[hi[B
   * Ȃ킿AR[h̓ꐫ <code>record1.equals(record2)</code> ł͂Ȃ
   * <code>record1 == record2</code> ɂ蔻肳B
   * ̂߁A{@link #add(java.lang.Object)}\bh
   * sۂɕʃIuWFNgŃJƃL[̑gݍ킹R[h㏑
   * ꂽ肷邱ƂȂA܂A{@link #remove(java.lang.Object)}s
   * ۂɁAJƃL[̑gݍ킹ʂ̃R[h폜ꂽ肷邱
   * ͂ȂB
   */
  protected class RecordSet extends IdentityHashSet<Record<C,V>>
  {
    /** VAEo[WԍB */
    static final long serialVersionUID = 5528842630870790522L;
  }
}

