/* $Id: edgelist2.h 4464 2015-11-30 09:57:27Z mskala $ */
/* Copyright (C) 2004-2012  George Williams
 * Copyright (C) 2015  Matthew Skala
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _EDGELIST2_H
#   define _EDGELIST2_H
#   include "splinefont.h"

struct monotonic;

typedef struct mlist {
    Spline *s;
    struct monotonic *m;			/* May get slightly munched but will */
			/* always have right spline. we fix when we need it */
    double t;
    int isend;
    BasePoint unit;
    struct mlist *next;
} MList;

typedef struct intersection {
    MList *monos;
    BasePoint inter;
    struct intersection *next;
} Intersection;
 
typedef struct preintersection {
    BasePoint inter;
    struct monotonic *m1; double t1;
    struct monotonic *m2; double t2;
    unsigned int is_close: 1;
    struct preintersection *next;
} PreIntersection;    

#define FF_RELATIONAL_GEOM

typedef struct monotonic {
    Spline *s;
    double tstart, tend;
#ifdef FF_RELATIONAL_GEOM
    double otstart, otend;
#endif
    struct monotonic *next, *prev;	/* along original contour */
    uint8_t xup;				/* increasing t => increasing x */
    uint8_t yup;
    unsigned int isneeded : 1;
    unsigned int isunneeded : 1;
    unsigned int mutual_collapse : 1;
    unsigned int exclude : 1;
    struct intersection *start;
    struct intersection *end;
    DBounds b;
    double other, t;
    struct monotonic *linked;		/* singly linked list of all monotonic*/
    					/*  segments, no contour indication */
    double when_set;			/* Debugging */
    struct preintersection *pending;
} Monotonic;

extern void FreeMonotonics(Monotonic *m);
extern Monotonic *SSsToMContours(SplineSet *spl, enum overlap_type ot);
	/* overlap_type controls whether we look at selected splinesets or all splinesets */
extern int MonotonicFindAt(Monotonic *ms,int which, double test, Monotonic **space );

#endif /* _EDGELIST2_H */
