/* $Id: namehash.h 4020 2015-06-14 18:15:09Z mskala $ */
/* Copyright (C) 2009-2012  George Williams
 * Copyright (C) 2015  Matthew Skala
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _NAMEHASH_H
#   define _NAMEHASH_H

#   define GN_HSIZE	257

struct glyphnamebucket {
   SplineChar *sc;
   struct glyphnamebucket *next;
   char *name;
};

struct glyphnamehash {
   struct glyphnamebucket *table[GN_HSIZE];
};

#   ifndef __GNUC__
#      define __inline__
#   endif

static __inline__ int hashname(const char *pt) {
   int val=0;

   while (*pt) {
      val=(val << 3) | ((val >> 29) & 0x7);
      val ^= (unsigned char) (*pt - '!');
      pt++;
   }
   val ^= (val >> 16);
   val &= 0xffff;
   val %= GN_HSIZE;
   return (val);
}

extern void __GlyphHashFree(struct glyphnamehash *hash);
#endif
