/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class VerifyResponse
extends Message {
    private static Logger _log = Logger.getLogger(VerifyResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("is_valid");
    protected static final List optionalFields = Arrays.asList("ns", "invalidate_handle");

    protected VerifyResponse(boolean compatibility) {
        this.setSignatureVerified(false);
        if (!compatibility) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected VerifyResponse(ParameterList params) {
        super(params);
    }

    public static VerifyResponse createVerifyResponse(boolean compatibility) throws MessageException {
        VerifyResponse resp = new VerifyResponse(compatibility);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            _log.debug((Object)("Created verification response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public static VerifyResponse createVerifyResponse(ParameterList params) throws MessageException {
        VerifyResponse resp = new VerifyResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            _log.debug((Object)("Created verification response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    public void setSignatureVerified(boolean verified) {
        this.set("is_valid", verified ? "true" : "false");
    }

    public boolean isSignatureVerified() {
        return "true".equals(this.getParameterValue("is_valid"));
    }

    public void setInvalidateHandle(String handle) {
        this.set("invalidate_handle", handle);
    }

    public String getInvalidateHandle() {
        return this.getParameterValue("invalidate_handle");
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (!"true".equals(this.getParameterValue("is_valid")) && !"false".equals(this.getParameterValue("is_valid"))) {
            _log.warn((Object)("Invalid is_valid value in verification response: " + this.getParameterValue("is_valid")));
            return false;
        }
        return true;
    }
}

