/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;

public class StoreRequest
extends AxMessage {
    private static Logger _log = Logger.getLogger(StoreRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected StoreRequest() {
        this._parameters.set(new Parameter("mode", "store_request"));
        if (DEBUG) {
            _log.debug((Object)"Created empty store request.");
        }
    }

    public static StoreRequest createStoreRequest() {
        return new StoreRequest();
    }

    protected StoreRequest(ParameterList params) {
        this._parameters = params;
    }

    public static StoreRequest createStoreRequest(ParameterList params) throws MessageException {
        StoreRequest req = new StoreRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a store request");
        }
        if (DEBUG) {
            _log.debug((Object)("Created store request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String alias, String typeUri, String value) {
        int count = this.getCount(alias);
        String index = "";
        switch (count) {
            case 0: {
                this._parameters.set(new Parameter("type." + alias, typeUri));
                break;
            }
            case 1: {
                this._parameters.set(new Parameter("value." + alias + ".1", this.getParameterValue("value." + alias)));
                this._parameters.removeParameters("value." + alias);
                index = ".2";
                break;
            }
            default: {
                index = "." + Integer.toString(count + 1);
            }
        }
        this._parameters.set(new Parameter("value." + alias + index, value));
        this.setCount(alias, ++count);
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to store request; type: " + typeUri + " alias: " + alias + " count: " + count));
        }
    }

    public List getAttributeValues(String alias) {
        ArrayList<String> values = new ArrayList<String>();
        if (!this._parameters.hasParameter("count." + alias)) {
            values.add(this.getParameterValue("value." + alias));
        } else {
            for (int i = 1; i <= this.getCount(alias); ++i) {
                values.add(this.getParameterValue("value." + alias + "." + Integer.toString(i)));
            }
        }
        return values;
    }

    public List getAttributeAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("value.") || aliases.contains(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Map getAttributes() {
        HashMap<String, List> attributes = new HashMap<String, List>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("value.") || attributes.containsKey(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            attributes.put(alias, this.getAttributeValues(alias));
        }
        return attributes;
    }

    public int getCount(String alias) {
        if (this._parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this._parameters.getParameterValue("count." + alias));
        }
        if (this._parameters.hasParameter("value." + alias)) {
            return 1;
        }
        return 0;
    }

    private void setCount(String alias, int count) {
        this._parameters.removeParameters("count." + alias);
        if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public boolean isValid() {
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("value.") || paramName.startsWith("count.")) continue;
            _log.warn((Object)("Invalid parameter name in store request: " + paramName));
        }
        return this.checkAttributes();
    }

    private boolean checkAttributes() {
        List aliases = this.getAttributeAliases();
        for (String alias : aliases) {
            if (!this._parameters.hasParameter("type." + alias)) {
                _log.warn((Object)("Type missing for attribute alias: " + alias));
                return false;
            }
            if (!this._parameters.hasParameter("count." + alias)) {
                if (this._parameters.hasParameter("value." + alias)) continue;
                _log.warn((Object)("Value missing for attribute alias: " + alias));
                return false;
            }
            if (this._parameters.hasParameter("value." + alias)) {
                _log.warn((Object)("Count parameter present for alias: " + alias + "; should use " + alias + ".[index] format"));
                return false;
            }
            int count = this.getCount(alias);
            for (int i = 1; i <= count; ++i) {
                if (this._parameters.hasParameter("value." + alias + "." + Integer.toString(i))) continue;
                _log.warn((Object)("Value missing for alias: " + alias + "." + Integer.toString(i)));
                return false;
            }
        }
        return true;
    }
}

