/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.association;

import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationSessionType
implements Comparable<AssociationSessionType> {
    private static final Log LOG = LogFactory.getLog(AssociationSessionType.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final AssociationSessionType NO_ENCRYPTION_SHA1MAC = new AssociationSessionType("no-encryption", null, "HMAC-SHA1", false, 0);
    public static final AssociationSessionType NO_ENCRYPTION_COMPAT_SHA1MAC = new AssociationSessionType("", null, "HMAC-SHA1", true, 1);
    public static final AssociationSessionType NO_ENCRYPTION_SHA256MAC = new AssociationSessionType("no-encryption", null, "HMAC-SHA256", false, 2);
    public static final AssociationSessionType DH_SHA1 = new AssociationSessionType("DH-SHA1", "SHA-1", "HMAC-SHA1", false, 3);
    public static final AssociationSessionType DH_COMPAT_SHA1 = new AssociationSessionType("DH-SHA1", "SHA-1", "HMAC-SHA1", true, 4);
    public static final AssociationSessionType DH_SHA256 = new AssociationSessionType("DH-SHA256", "SHA-256", "HMAC-SHA256", false, 5);
    private String sessType;
    private String hAlgorithm;
    private String assocType;
    private boolean compat;
    private int order;

    private AssociationSessionType(String sessType, String hAlgorithm, String assocType, boolean compat, int order) {
        this.sessType = sessType;
        this.hAlgorithm = hAlgorithm;
        this.assocType = assocType;
        this.compat = compat;
        this.order = order;
    }

    public static AssociationSessionType create(String sessType) throws AssociationException {
        return AssociationSessionType.create(sessType, "HMAC-SHA1");
    }

    public static AssociationSessionType create(String sessType, String assocType) throws AssociationException {
        return AssociationSessionType.create(sessType, assocType, false);
    }

    public static AssociationSessionType create(String sessType, String assocType, boolean compatibility) throws AssociationException {
        AssociationSessionType result;
        if (!compatibility && "no-encryption".equals(sessType) && "HMAC-SHA1".equals(assocType)) {
            result = NO_ENCRYPTION_SHA1MAC;
        } else if (!compatibility && "no-encryption".equals(sessType) && "HMAC-SHA256".equals(assocType)) {
            result = NO_ENCRYPTION_SHA1MAC;
        } else if (compatibility && ("".equals(sessType) || sessType == null) && ("HMAC-SHA1".equals(assocType) || assocType == null)) {
            result = NO_ENCRYPTION_COMPAT_SHA1MAC;
        } else if (!compatibility && "DH-SHA1".equals(sessType) && "HMAC-SHA1".equals(assocType)) {
            result = DH_SHA1;
        } else if (compatibility && ("DH-SHA1".equals(sessType) || sessType == null)) {
            result = DH_COMPAT_SHA1;
        } else if (!compatibility && "DH-SHA256".equals(sessType) && "HMAC-SHA256".equals(assocType)) {
            result = DH_SHA256;
        } else {
            throw new AssociationException("Unsupported session / association type: " + sessType + " : " + assocType + ", compatibility: " + compatibility);
        }
        if (DEBUG) {
            LOG.debug((Object)("Session:Association Type: " + result));
        }
        return result;
    }

    public String getSessionType() {
        return this.sessType;
    }

    public String getHAlgorithm() {
        return this.hAlgorithm;
    }

    public String getAssociationType() {
        return this.assocType;
    }

    public int getKeySize() {
        if ("HMAC-SHA1".equals(this.assocType)) {
            return 160;
        }
        if ("HMAC-SHA256".equals(this.assocType)) {
            return 256;
        }
        return 0;
    }

    @Override
    public int compareTo(AssociationSessionType that) {
        if (this.order == that.order) {
            return 0;
        }
        return this.order > that.order ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AssociationSessionType) {
            return this.compareTo((AssociationSessionType)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.order;
    }

    public boolean isBetter(AssociationSessionType other) {
        return this.compareTo(other) > 0;
    }

    public boolean isVersion2() {
        return !this.compat;
    }

    public String toString() {
        return this.sessType + ":" + this.assocType + ":" + (this.compat ? "OpenID1" : "OpenID2");
    }
}

