/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.op.impl;

import java.util.Date;
import jp.sourceforge.tsukuyomi.openid.op.NonceGenerator;
import jp.sourceforge.tsukuyomi.openid.util.InternetDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncrementalNonceGenerator
implements NonceGenerator {
    private static final Log LOG = LogFactory.getLog(IncrementalNonceGenerator.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private String timestamp = "";
    private int counter = 0;

    public synchronized String next() {
        String currentTimestamp = this.getCurrentTimpestamp();
        if (this.timestamp.equals(currentTimestamp)) {
            ++this.counter;
        } else {
            this.timestamp = currentTimestamp;
            this.counter = 0;
        }
        String nonce = this.timestamp + Integer.toString(this.counter);
        if (DEBUG) {
            LOG.debug((Object)("Generated nonce: " + nonce));
        }
        return nonce;
    }

    private String getCurrentTimpestamp() {
        Date now = new Date();
        InternetDateFormat dateFormat = new InternetDateFormat();
        return dateFormat.format(now);
    }
}

