/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class AuthImmediateFailure extends Message {
	private static final Log LOG =
		LogFactory.getLog(AuthImmediateFailure.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	protected static final List<String> REQUIRED_FIELDS =
		Arrays.asList(new String[] { "openid.mode" });

	protected static final List<String> OPTIONAL_FIELDS =
		Arrays.asList(new String[] { "openid.ns", "openid.user_setup_url" });

	protected AuthImmediateFailure(String url, String returnTo,
			boolean compatibility) {
		if (compatibility) {
			set("openid.mode", MODE_IDRES);
			set("openid.user_setup_url", url);
		} else {
			set("openid.mode", MODE_SETUP_NEEDED);
			set("openid.ns", OPENID2_NS);
		}

		destinationUrl = returnTo;
	}

	protected AuthImmediateFailure(ParameterList params) {
		super(params);
	}

	public static AuthImmediateFailure createAuthImmediateFailure(String url,
			String returnTo, boolean compatibility) throws MessageException {
		AuthImmediateFailure fail =
			new AuthImmediateFailure(url, returnTo, compatibility);

		if (!fail.isValid()) {
			throw new MessageException(
				"Invalid set of parameters for the requested message type");
		}

		return fail;
	}

	public static AuthImmediateFailure createAuthImmediateFailure(
			ParameterList params) throws MessageException {
		AuthImmediateFailure fail = new AuthImmediateFailure(params);

		if (!fail.isValid()) {
			throw new MessageException(
				"Invalid set of parameters for the requested message type");
		}

		if (DEBUG) {
			LOG
				.debug("Retrieved auth immediate failure from message parameters:\n"
					+ fail.keyValueFormEncoding());
		}

		return fail;
	}

	@Override
	public List<String> getRequiredFields() {
		return REQUIRED_FIELDS;
	}

	public boolean isVersion2() {
		return hasParameter("openid.ns")
			&& OPENID2_NS.equals(getParameterValue("openid.ns"));
	}

	public String getUserSetupUrl() {
		return getParameterValue("openid.user_setup_url");
	}

	@Override
	public boolean isValid() {
		if (!super.isValid()) {
			return false;
		}

		boolean compatibility = !isVersion2();

		if (compatibility) {
			try {
				new URL(getUserSetupUrl());
			} catch (MalformedURLException e) {
				LOG.error(
					"Error verifying auth immediate response validity.",
					e);
				return false;
			}

			return MODE_IDRES.equals(getParameterValue("openid.mode"));
		} else {
			return MODE_SETUP_NEEDED.equals(getParameterValue("openid.mode"));
		}
	}
}
