/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.discovery;

import java.io.Serializable;
import java.net.URL;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;

public class DiscoveryInformation
implements Serializable {
    private static final long serialVersionUID = -2586780820659310850L;
    private URL idpEndpoint;
    private Identifier claimedIdentifier;
    private String delegate;
    private String version;
    public static final String OPENID10 = "http://openid.net/signon/1.0";
    public static final String OPENID11 = "http://openid.net/signon/1.1";
    public static final String OPENID2 = "http://specs.openid.net/auth/2.0/signon";
    public static final String OPENID2_OP = "http://specs.openid.net/auth/2.0/server";

    public DiscoveryInformation(URL idpEndpoint) throws DiscoveryException {
        this(idpEndpoint, null, OPENID2_OP);
    }

    public DiscoveryInformation(URL idpEndpoint, Identifier claimedIdentifier) throws DiscoveryException {
        this(idpEndpoint, claimedIdentifier, OPENID2);
    }

    public DiscoveryInformation(URL idpEndpoint, Identifier claimedIdentifier, String version) throws DiscoveryException {
        this(idpEndpoint, claimedIdentifier, null, version);
    }

    public DiscoveryInformation(URL idpEndpoint, Identifier claimedIdentifier, String delegate, String version) throws DiscoveryException {
        this.idpEndpoint = idpEndpoint;
        this.claimedIdentifier = claimedIdentifier;
        this.version = version;
        this.delegate = delegate;
        if (this.idpEndpoint == null) {
            throw new DiscoveryException("Null OpenID Provider endpoint.");
        }
        if (this.delegate != null && this.claimedIdentifier == null) {
            throw new DiscoveryException("Claimed ID must be present if delegated ID is used.");
        }
    }

    public boolean hasClaimedIdentifier() {
        return this.claimedIdentifier != null;
    }

    public boolean hasDelegateIdentifier() {
        return this.delegate != null;
    }

    public URL getIdpEndpoint() {
        return this.idpEndpoint;
    }

    public Identifier getClaimedIdentifier() {
        return this.claimedIdentifier;
    }

    public String getDelegateIdentifier() {
        return this.delegate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isVersion2() {
        return OPENID2.equals(this.version) || OPENID2_OP.equals(this.version);
    }

    public String toString() {
        return String.valueOf(this.isVersion2() ? "OpenID2" : "OpenID1") + "\nOP-endpoint:" + this.idpEndpoint + "\nClaimedID:" + this.claimedIdentifier + "\nDelegate:" + this.delegate;
    }
}

