/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.discovery;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlIdentifier
implements Identifier {
    private static final long serialVersionUID = 1740585702985022532L;
    private static final Log LOG = LogFactory.getLog(UrlIdentifier.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Set<Character> UNRESERVED_CHARACTERS = new HashSet<Character>();
    private URL urlIdentifier;

    static {
        char c = 'a';
        while (c <= 'z') {
            UNRESERVED_CHARACTERS.add(Character.valueOf(c));
            c = (char)(c + 1);
        }
        c = 'A';
        while (c <= 'A') {
            UNRESERVED_CHARACTERS.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        c = '0';
        while (c <= '9') {
            UNRESERVED_CHARACTERS.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        UNRESERVED_CHARACTERS.add(Character.valueOf('-'));
        UNRESERVED_CHARACTERS.add(Character.valueOf('.'));
        UNRESERVED_CHARACTERS.add(Character.valueOf('_'));
        UNRESERVED_CHARACTERS.add(Character.valueOf('~'));
    }

    public UrlIdentifier(String identifier) throws IdentifierException {
        this.urlIdentifier = UrlIdentifier.normalize(identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlIdentifier that = (UrlIdentifier)o;
        return this.urlIdentifier.equals(that.urlIdentifier);
    }

    public int hashCode() {
        return this.urlIdentifier.hashCode();
    }

    public String getIdentifier() {
        return this.urlIdentifier.toExternalForm();
    }

    public String toString() {
        return this.urlIdentifier.toExternalForm();
    }

    public URL getUrl() {
        return this.urlIdentifier;
    }

    public static URL normalize(String text) throws IdentifierException {
        try {
            String file;
            URI uri = new URI(text);
            URL url = uri.normalize().toURL();
            String protocol = url.getProtocol().toLowerCase();
            String host = url.getHost().toLowerCase();
            int port = url.getPort();
            String path = UrlIdentifier.normalizeUrlEncoding(url.getPath());
            String query = UrlIdentifier.normalizeUrlEncoding(url.getQuery());
            String fragment = UrlIdentifier.normalizeUrlEncoding(url.getRef());
            if (port == url.getDefaultPort()) {
                port = -1;
            }
            if ("".equals(file = path)) {
                file = "/";
            }
            if (query != null) {
                file = String.valueOf(file) + "?" + query;
            }
            if (fragment != null) {
                file = String.valueOf(file) + "#" + fragment;
            }
            URL normalized = new URL(protocol, host, port, file);
            if (DEBUG) {
                LOG.debug((Object)("Normalized: " + text + " to: " + normalized));
            }
            return normalized;
        }
        catch (MalformedURLException e) {
            throw new IdentifierException("Invalid URL identifier", e);
        }
        catch (URISyntaxException e) {
            throw new IdentifierException("Invalid URL identifier", e);
        }
    }

    private static String normalizeUrlEncoding(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuffer normalized = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char current = text.charAt(i);
            if (current == '%' && i < len - 2) {
                String percentCode = text.substring(i, i + 3).toUpperCase();
                try {
                    String str = URLDecoder.decode(percentCode, "ISO-8859-1");
                    char chr = str.charAt(0);
                    if (UNRESERVED_CHARACTERS.contains(Character.valueOf(chr))) {
                        normalized.append(chr);
                    } else {
                        normalized.append(percentCode);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    normalized.append(percentCode);
                }
                i += 2;
            } else {
                normalized.append(current);
            }
            ++i;
        }
        return normalized.toString();
    }
}

