/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.discovery.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.HtmlResolver;
import jp.sourceforge.tsukuyomi.openid.discovery.HtmlResult;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.discovery.UrlIdentifier;
import jp.sourceforge.tsukuyomi.openid.http.HttpClientManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;

public class HtmlResolverImpl
implements HtmlResolver {
    private static final Log LOG = LogFactory.getLog(HtmlResolverImpl.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private HttpClientManager httpClientManager;

    public HtmlResult discover(UrlIdentifier identifier) throws DiscoveryException, IdentifierException {
        HtmlResult result = new HtmlResult();
        String htmlData = this.call(identifier.getUrl(), result);
        this.parseHtml(htmlData, result);
        LOG.info((Object)("HTML discovery succeeded on: " + identifier));
        return result;
    }

    private String call(URL url, HtmlResult result) throws DiscoveryException, IdentifierException {
        HttpClient client = this.httpClientManager.getHttpClient();
        GetMethod get = new GetMethod(url.toString());
        get.setFollowRedirects(true);
        try {
            int statusCode;
            if (DEBUG) {
                LOG.debug((Object)("Fetching " + url + "..."));
            }
            if ((statusCode = client.executeMethod((HttpMethod)get)) != 200) {
                throw new DiscoveryException("GET failed on " + url + " Received status code: " + statusCode);
            }
            result.setClaimed(new UrlIdentifier(get.getURI().toString()));
            InputStream htmlInput = get.getResponseBodyAsStream();
            if (htmlInput == null) {
                throw new DiscoveryException("Cannot open inputstream for GET response from " + url);
            }
            byte[] data = new byte[this.httpClientManager.getMaxHtmlSize()];
            int totalRead = 0;
            int currentRead = 0;
            while (totalRead < this.httpClientManager.getMaxHtmlSize()) {
                currentRead = htmlInput.read(data, totalRead, this.httpClientManager.getMaxHtmlSize() - totalRead);
                if (currentRead == -1) break;
                totalRead += currentRead;
            }
            htmlInput.close();
            if (totalRead <= 0) {
                throw new DiscoveryException("No HTML data read from " + url);
            }
            if (DEBUG) {
                LOG.debug((Object)("Read " + totalRead + " bytes."));
            }
            String string = new String(data, 0, totalRead);
            return string;
        }
        catch (IOException e) {
            throw new DiscoveryException("Fatal transport error: ", e);
        }
        finally {
            get.releaseConnection();
        }
    }

    private void parseHtml(String htmlData, HtmlResult result) throws DiscoveryException {
        Object idp1Endpoint = null;
        Object idp2Endpoint = null;
        if (DEBUG) {
            LOG.debug((Object)("Parsing HTML data:\n" + htmlData));
        }
        try {
            Parser parser = Parser.createParser((String)htmlData, null);
            NodeList heads = parser.parse((NodeFilter)new TagNameFilter("HEAD"));
            if (heads.size() != 1) {
                throw new DiscoveryException("HTML response must have exactly one HEAD element, found " + heads.size() + " : " + heads.toHtml());
            }
            Node head = heads.elementAt(0);
            SimpleNodeIterator i = head.getChildren().elements();
            while (i.hasMoreNodes()) {
                List<String> relations;
                Node node = i.nextNode();
                if (!(node instanceof TagNode)) continue;
                TagNode link = (TagNode)node;
                String href = link.getAttribute("href");
                String rel = link.getAttribute("rel");
                if (rel == null || (relations = Arrays.asList(rel.split(" "))) == null) continue;
                if (relations.contains("openid.server")) {
                    if (result.getIdp1Endpoint() != null) {
                        throw new DiscoveryException("More than one openid.server entries found");
                    }
                    if (DEBUG) {
                        LOG.debug((Object)("Found OpenID1 endpoint: " + idp1Endpoint));
                    }
                    result.setEndpoint1(href);
                }
                if (relations.contains("openid.delegate")) {
                    if (result.getDelegate1() != null) {
                        throw new DiscoveryException("More than one openid.delegate entries found");
                    }
                    if (DEBUG) {
                        LOG.debug((Object)("Found OpenID1 delegate: " + href));
                    }
                    result.setDelegate1(href);
                }
                if (relations.contains("openid2.provider")) {
                    if (result.getIdp2Endpoint() != null) {
                        throw new DiscoveryException("More than one openid.server entries found");
                    }
                    if (DEBUG) {
                        LOG.debug((Object)("Found OpenID2 endpoint: " + idp2Endpoint));
                    }
                    result.setEndpoint2(href);
                }
                if (!relations.contains("openid2.local_id")) continue;
                if (result.getDelegate2() != null) {
                    throw new DiscoveryException("More than one openid2.local_id entries found");
                }
                if (DEBUG) {
                    LOG.debug((Object)("Found OpenID2 localID: " + href));
                }
                result.setDelegate2(href);
            }
            if (DEBUG) {
                LOG.debug((Object)("HTML discovery result:\n" + result));
            }
        }
        catch (ParserException e) {
            throw new DiscoveryException("Error parsing HTML message", e);
        }
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }
}

