/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.http.impl;

import jp.sourceforge.tsukuyomi.openid.http.HttpClientManager;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.lang.StringUtils;

public class HttpClientManagerImpl
implements HttpClientManager {
    private int maxRedirects = 10;
    private int maxHtmlSize = 100000;
    private int maxXmlSize = 100000;
    private int connTimeout = 3000;
    private int socketTimeout = 5000;
    private int proxyPort = -1;
    private String proxyPassword;
    private String proxyHostName;
    private String proxyUserName;

    public HttpClient getHttpClient() {
        return this.getHttpClient(true);
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public int getMaxHtmlSize() {
        return this.maxHtmlSize;
    }

    public void setMaxHtmlSize(int maxHtmlSize) {
        this.maxHtmlSize = maxHtmlSize;
    }

    public int getMaxXmlSize() {
        return this.maxXmlSize;
    }

    public void setMaxXmlSize(int maxXmlSize) {
        this.maxXmlSize = maxXmlSize;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyHostName() {
        return this.proxyHostName;
    }

    public void setProxyHostName(String proxyHostName) {
        this.proxyHostName = proxyHostName;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public HttpClient getHttpClient(Boolean allowCircularRedirects) {
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getParams().setParameter("http.protocol.max-redirects", (Object)this.maxRedirects);
        client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)allowCircularRedirects);
        client.getParams().setSoTimeout(this.socketTimeout);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(this.connTimeout);
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        HostConfiguration hostConf = client.getHostConfiguration();
        if (this.proxyPort >= 0 && !StringUtils.isBlank((String)this.proxyHostName)) {
            hostConf.setProxy(this.proxyHostName, this.proxyPort);
        }
        if (!StringUtils.isBlank((String)this.proxyUserName) && !StringUtils.isBlank((String)this.proxyPassword)) {
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            client.getState().setProxyCredentials(authScope, (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.proxyPassword));
        }
        return client;
    }
}

