/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthFailure
extends Message {
    private static final Log LOG = LogFactory.getLog(AuthFailure.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("openid.mode");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("openid.ns");

    public AuthFailure(boolean compatibility, String returnTo) {
        this.set("openid.mode", "cancel");
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
        this.destinationUrl = returnTo;
    }

    protected AuthFailure(ParameterList params) {
        super(params);
    }

    public static AuthFailure createAuthFailure(ParameterList params) throws MessageException {
        AuthFailure fail = new AuthFailure(params);
        if (!fail.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Retrieved auth failure from message parameters:\n" + fail.keyValueFormEncoding()));
        }
        return fail;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return "cancel".equals(this.getParameterValue("openid.mode"));
    }
}

