/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtension;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.op.RealmVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthRequest
extends Message {
    private static final Log LOG = LogFactory.getLog(AuthRequest.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String MODE_SETUP = "checkid_setup";
    public static final String MODE_IMMEDIATE = "checkid_immediate";
    public static final String SELECT_ID = "http://specs.openid.net/auth/2.0/identifier_select";
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("openid.mode");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("openid.ns", "openid.claimed_id", "openid.identity", "openid.assoc_handle", "openid.realm", "openid.trust_root", "openid.return_to");
    private RealmVerifier _realmVerifier;

    protected AuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, RealmVerifier verifier) {
        this(claimedId, delegate, compatibility, returnToUrl, handle, returnToUrl, verifier);
    }

    protected AuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, String realm, RealmVerifier verifier) {
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
            this.setClaimed(claimedId);
        }
        this.setIdentity(delegate);
        if (returnToUrl != null) {
            this.setReturnTo(returnToUrl);
        }
        if (realm != null) {
            this.setRealm(realm);
        }
        if (!" ".equals(handle)) {
            this.setHandle(handle);
        }
        this.setImmediate(false);
        this._realmVerifier = verifier;
    }

    protected AuthRequest(ParameterList params) {
        super(params);
    }

    public static AuthRequest createAuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, RealmVerifier verifier) throws MessageException {
        return AuthRequest.createAuthRequest(claimedId, delegate, compatibility, returnToUrl, handle, returnToUrl, verifier);
    }

    public static AuthRequest createAuthRequest(String claimedId, String delegate, boolean compatibility, String returnToUrl, String handle, String realm, RealmVerifier verifier) throws MessageException {
        AuthRequest req = new AuthRequest(claimedId, delegate, compatibility, returnToUrl, handle, realm, verifier);
        if (!req.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created auth request:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public static AuthRequest createAuthRequest(ParameterList params, RealmVerifier realmVerifier) throws MessageException {
        AuthRequest req = new AuthRequest(params);
        req.setRealmVerifier(realmVerifier);
        if (!req.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created auth request:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public void setOPEndpoint(URL opEndpoint) {
        if (opEndpoint != null) {
            this.destinationUrl = opEndpoint.toString();
        }
    }

    public String getOPEndpoint() {
        return this.destinationUrl;
    }

    public void setImmediate(boolean immediate) {
        this.set("openid.mode", immediate ? MODE_IMMEDIATE : MODE_SETUP);
        if (DEBUG && immediate) {
            LOG.debug((Object)"Setting checkid_immediate auth request.");
        }
    }

    public boolean isImmediate() {
        return MODE_IMMEDIATE.equals(this.getParameterValue("openid.mode"));
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public void setIdentity(String id) {
        this.set("openid.identity", id);
    }

    public String getIdentity() {
        return this.getParameterValue("openid.identity");
    }

    public void setClaimed(String claimed) {
        this.set("openid.claimed_id", claimed);
    }

    public String getClaimed() {
        return this.getParameterValue("openid.claimed_id");
    }

    public void setHandle(String handle) {
        this.set("openid.assoc_handle", handle);
    }

    public String getHandle() {
        return this.getParameterValue("openid.assoc_handle");
    }

    public void setReturnTo(String returnTo) {
        this.set("openid.return_to", returnTo);
    }

    public String getReturnTo() {
        return this.getParameterValue("openid.return_to");
    }

    public void setRealm(String realm) {
        this.set(this.isVersion2() ? "openid.realm" : "openid.trust_root", realm);
    }

    public String getRealm() {
        if (this.isVersion2()) {
            return this.getParameterValue("openid.realm");
        }
        return this.getParameterValue("openid.trust_root");
    }

    public RealmVerifier getRealmVerifier() {
        return this._realmVerifier;
    }

    public void setRealmVerifier(RealmVerifier realmVerifier) {
        this._realmVerifier = realmVerifier;
    }

    @Override
    public boolean isValid() {
        boolean compatibility;
        if (!super.isValid()) {
            return false;
        }
        boolean bl = compatibility = !this.isVersion2();
        if (compatibility && this.hasParameter("openid.ns")) {
            LOG.warn((Object)("Invalid value for openid.ns field: " + this.getParameterValue("openid.ns")));
            return false;
        }
        if (compatibility && this.hasParameter("openid.identity") && SELECT_ID.equals(this.getParameterValue("openid.identity"))) {
            LOG.warn((Object)"http://specs.openid.net/auth/2.0/identifier_select not supported in OpenID1");
            return false;
        }
        if (this.hasParameter("openid.mode") && !MODE_SETUP.equals(this.getParameterValue("openid.mode")) && !MODE_IMMEDIATE.equals(this.getParameterValue("openid.mode"))) {
            LOG.warn((Object)("Invalid openid.mode value in auth request: " + this.getParameterValue("openid.mode")));
            return false;
        }
        try {
            if (this.getReturnTo() != null) {
                new URL(this.getReturnTo());
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Error verifying return URL in auth request.", (Throwable)e);
            return false;
        }
        if (!this.hasParameter("openid.return_to")) {
            if (compatibility) {
                LOG.warn((Object)"openid.return_to is mandatory in OpenID1 auth requests");
                return false;
            }
            if (!this.hasParameter("openid.realm")) {
                LOG.warn((Object)"openid.realm is mandatory in Openid2 auth requests");
                return false;
            }
        }
        if (compatibility && this.hasParameter("openid.realm")) {
            LOG.warn((Object)"openid.realm should not be present in OpenID1 auth requests");
        }
        if (!compatibility && this.hasParameter("openid.trust_root")) {
            LOG.warn((Object)"openid.trust_root should not be present in OpenID2 auth requests.");
        }
        if (!this.hasParameter("openid.identity")) {
            if (compatibility) {
                LOG.warn((Object)"openid.identity is required in OpenID1 auth requests");
                return false;
            }
            boolean hasAuthProvider = false;
            for (String typeUri : this.getExtensions()) {
                try {
                    MessageExtension extension = this.getExtension(typeUri);
                    if (!extension.providesIdentifier()) continue;
                    hasAuthProvider = true;
                    break;
                }
                catch (MessageException messageException) {
                    // empty catch block
                }
            }
            if (!hasAuthProvider) {
                LOG.warn((Object)"no identifier specified in auth request");
                return false;
            }
            if (this.hasParameter("openid.claimed_id")) {
                LOG.warn((Object)"openid.claimed_id must be present if and only if openid.identity is present.");
                return false;
            }
        } else if (!compatibility && !this.hasParameter("openid.claimed_id")) {
            LOG.warn((Object)"openid.clamied_id must be present in OpenID2 auth requests");
            return false;
        }
        if (this.getRealm() != null && this._realmVerifier.match(this.getRealm(), this.getReturnTo()) != 0) {
            LOG.warn((Object)("Realm verification failed for: " + this.getRealm()));
            return false;
        }
        return true;
    }
}

