/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.ax.AxMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchRequest
extends AxMessage {
    private static final Log LOG = LogFactory.getLog(FetchRequest.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    protected FetchRequest() {
        this.parameters.set(new Parameter("mode", "fetch_request"));
        if (DEBUG) {
            LOG.debug((Object)"Created empty fetch request.");
        }
    }

    public static FetchRequest createFetchRequest() {
        return new FetchRequest();
    }

    protected FetchRequest(ParameterList params) {
        this.parameters = params;
    }

    public static FetchRequest createFetchRequest(ParameterList params) throws MessageException {
        FetchRequest req = new FetchRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a fetch request");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created fetch request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String alias, String typeUri, boolean required, int count) {
        Parameter newParam;
        this.parameters.set(new Parameter("type." + alias, typeUri));
        String level = required ? "required" : "if_available";
        Parameter levelParam = this.parameters.getParameter(level);
        if (levelParam == null) {
            newParam = new Parameter(level, this.multivalEncode(alias));
        } else {
            newParam = new Parameter(level, String.valueOf(levelParam.getValue()) + "," + this.multivalEncode(alias));
            this.parameters.removeParameters(level);
        }
        this.parameters.set(newParam);
        if (count > 1) {
            this.parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
        if (DEBUG) {
            LOG.debug((Object)("Added new attribute to fetch request; type: " + typeUri + " alias: " + alias + " count: " + count + " required: " + required));
        }
    }

    public void addAttribute(String alias, String typeUri, boolean required) {
        this.addAttribute(alias, typeUri, required, 1);
    }

    public void setCount(String alias, int count) {
        if (count > 1) {
            this.parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public int getCount(String alias) {
        if (this.parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this.parameters.getParameterValue("count." + alias));
        }
        return 1;
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            LOG.debug((Object)("Setting fetch request update_url: " + updateUrl));
        }
        this.parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this.parameters.hasParameter("update_url") ? this.parameters.getParameterValue("update_url") : null;
    }

    public Map<String, Object> getAttributes(boolean required) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        String level = required ? "required" : "if_available";
        Parameter param = this.parameters.getParameter(level);
        if (param != null) {
            String[] values;
            String[] stringArray = values = param.getValue().split(",");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                String alias = this.multivalDecode(element);
                attributes.put(alias, this.parameters.getParameterValue("type." + alias));
                ++n2;
            }
        }
        return attributes;
    }

    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = this.getAttributes(true);
        attributes.putAll(this.getAttributes(false));
        return attributes;
    }

    public boolean isValid() {
        String value;
        String element;
        int n;
        int n2;
        String[] stringArray;
        String[] values;
        if (!this.parameters.hasParameter("required") && !this.parameters.hasParameter("if_available")) {
            LOG.warn((Object)"One of 'required' or 'if_available' parameters must be present.");
            return false;
        }
        if (!this.parameters.hasParameter("mode") || !"fetch_request".equals(this.parameters.getParameterValue("mode"))) {
            LOG.warn((Object)("Invalid mode value in fetch_request: " + this.parameters.getParameterValue("mode")));
            return false;
        }
        if (this.parameters.hasParameter("required")) {
            stringArray = values = this.parameters.getParameterValue("required").split(",");
            n2 = values.length;
            n = 0;
            while (n < n2) {
                element = stringArray[n];
                value = this.multivalDecode(element);
                if (!this.parameters.hasParameter("type." + value)) {
                    LOG.warn((Object)("Type missing for attribute alias: " + value));
                    return false;
                }
                ++n;
            }
        }
        if (this.parameters.hasParameter("if_available")) {
            stringArray = values = this.parameters.getParameterValue("if_available").split(",");
            n2 = values.length;
            n = 0;
            while (n < n2) {
                element = stringArray[n];
                value = this.multivalDecode(element);
                if (!this.parameters.hasParameter("type." + value)) {
                    LOG.warn((Object)("Type missing for attribute alias: " + value));
                    return false;
                }
                ++n;
            }
        }
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.equals("required") || paramName.equals("if_available") || paramName.equals("update_url")) continue;
            LOG.warn((Object)("Invalid parameter name in fetch request: " + paramName));
        }
        return true;
    }
}

