/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.ax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.ax.AxMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreRequest
extends AxMessage {
    private static final Log LOG = LogFactory.getLog(StoreRequest.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    protected StoreRequest() {
        this.parameters.set(new Parameter("mode", "store_request"));
        if (DEBUG) {
            LOG.debug((Object)"Created empty store request.");
        }
    }

    public static StoreRequest createStoreRequest() {
        return new StoreRequest();
    }

    protected StoreRequest(ParameterList params) {
        this.parameters = params;
    }

    public static StoreRequest createStoreRequest(ParameterList params) throws MessageException {
        StoreRequest req = new StoreRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a store request");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created store request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String alias, String typeUri, String value) {
        int count = this.getCount(alias);
        String index = "";
        switch (count) {
            case 0: {
                this.parameters.set(new Parameter("type." + alias, typeUri));
                break;
            }
            case 1: {
                this.parameters.set(new Parameter("value." + alias + ".1", this.getParameterValue("value." + alias)));
                this.parameters.removeParameters("value." + alias);
                index = ".2";
                break;
            }
            default: {
                index = "." + Integer.toString(count + 1);
            }
        }
        this.parameters.set(new Parameter("value." + alias + index, value));
        this.setCount(alias, ++count);
        if (DEBUG) {
            LOG.debug((Object)("Added new attribute to store request; type: " + typeUri + " alias: " + alias + " count: " + count));
        }
    }

    public List<String> getAttributeValues(String alias) {
        ArrayList<String> values = new ArrayList<String>();
        if (!this.parameters.hasParameter("count." + alias)) {
            values.add(this.getParameterValue("value." + alias));
        } else {
            int i = 1;
            while (i <= this.getCount(alias)) {
                values.add(this.getParameterValue("value." + alias + "." + Integer.toString(i)));
                ++i;
            }
        }
        return values;
    }

    public List<String> getAttributeAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (Parameter param : this.parameters.getParameters()) {
            String alias;
            String paramName = param.getKey();
            if (!paramName.startsWith("value.") || aliases.contains(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Parameter param : this.parameters.getParameters()) {
            String alias;
            String paramName = param.getKey();
            if (!paramName.startsWith("value.") || attributes.containsKey(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            attributes.put(alias, this.getAttributeValues(alias));
        }
        return attributes;
    }

    public int getCount(String alias) {
        if (this.parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this.parameters.getParameterValue("count." + alias));
        }
        if (this.parameters.hasParameter("value." + alias)) {
            return 1;
        }
        return 0;
    }

    private void setCount(String alias, int count) {
        this.parameters.removeParameters("count." + alias);
        if (count > 1) {
            this.parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public boolean isValid() {
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("value.") || paramName.startsWith("count.")) continue;
            LOG.warn((Object)("Invalid parameter name in store request: " + paramName));
        }
        return this.checkAttributes();
    }

    private boolean checkAttributes() {
        for (String alias : this.getAttributeAliases()) {
            if (!this.parameters.hasParameter("type." + alias)) {
                LOG.warn((Object)("Type missing for attribute alias: " + alias));
                return false;
            }
            if (!this.parameters.hasParameter("count." + alias)) {
                if (this.parameters.hasParameter("value." + alias)) continue;
                LOG.warn((Object)("Value missing for attribute alias: " + alias));
                return false;
            }
            if (this.parameters.hasParameter("value." + alias)) {
                LOG.warn((Object)("Count parameter present for alias: " + alias + "; should use " + alias + ".[index] format"));
                return false;
            }
            int count = this.getCount(alias);
            int i = 1;
            while (i <= count) {
                if (!this.parameters.hasParameter("value." + alias + "." + Integer.toString(i))) {
                    LOG.warn((Object)("Value missing for alias: " + alias + "." + Integer.toString(i)));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

