/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.pape;

import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtension;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtensionFactory;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.pape.PapeRequest;
import jp.sourceforge.tsukuyomi.openid.message.pape.PapeResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PapeMessage
implements MessageExtension,
MessageExtensionFactory {
    private static final Log LOG = LogFactory.getLog(PapeMessage.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String PAPE_POLICY_PHISHING_RESISTANT = "http://schemas.openid.net/pape/policies/2007/06/phishing-resistant";
    public static final String PAPE_POLICY_MULTI_FACTOR = "http://schemas.openid.net/pape/policies/2007/06/multi-factor";
    public static final String PAPE_POLICY_MULTI_FACTOR_PHYSICAL = "http://schemas.openid.net/pape/policies/2007/06/multi-factor-physical";
    public static final String OPENID_NS_PAPE = "http://specs.openid.net/extensions/pape/1.0";
    protected ParameterList parameters;

    public PapeMessage() {
        this.parameters = new ParameterList();
        if (DEBUG) {
            LOG.debug((Object)"Created empty PapeMessage.");
        }
    }

    public PapeMessage(ParameterList params) {
        this.parameters = params;
        if (DEBUG) {
            LOG.debug((Object)("Created PapeMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return OPENID_NS_PAPE;
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterList params) {
        this.parameters = params;
    }

    public boolean hasParameter(String name) {
        return this.parameters.hasParameter(name);
    }

    protected void set(String name, String value) {
        this.parameters.set(new Parameter(name, value));
    }

    protected Parameter getParameter(String name) {
        return this.parameters.getParameter(name);
    }

    public String getParameterValue(String name) {
        return this.parameters.getParameterValue(name);
    }

    public boolean providesIdentifier() {
        return false;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (parameterList.hasParameter("preferred_auth_policies") || parameterList.hasParameter("max_auth_age")) {
            return PapeRequest.createPapeRequest(parameterList);
        }
        if (parameterList.hasParameter("auth_policies") || parameterList.hasParameter("auth_age")) {
            return PapeResponse.createPapeResponse(parameterList);
        }
        throw new MessageException("Invalid parameters for a PAPE message.");
    }
}

