/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.pape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.pape.PapeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapeResponse
extends PapeMessage {
    private static final Log LOG = LogFactory.getLog(PapeResponse.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String AUTH_AGE_UNKNOWN = "unknown";
    protected static final List<String> PAPE_FIELDS = Arrays.asList("auth_policies", "auth_age", "nist_auth_level");

    protected PapeResponse() {
        this.set("auth_policies", "");
        if (DEBUG) {
            LOG.debug((Object)"Created empty PAPE response.");
        }
    }

    public static PapeResponse createPapeResponse() {
        return new PapeResponse();
    }

    protected PapeResponse(ParameterList params) {
        this.parameters = params;
    }

    public static PapeResponse createPapeResponse(ParameterList params) throws MessageException {
        PapeResponse resp = new PapeResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a PAPE response");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created PAPE response from parameter list:\n" + params));
        }
        return resp;
    }

    public String getAuthPolicies() {
        return this.getParameterValue("auth_policies");
    }

    public void setAuthPolicies(String policyUris) {
        this.set("auth_policies", policyUris);
    }

    public void addAuthPolicy(String policyUri) {
        String policies = this.getAuthPolicies();
        if (policies == null || policies.length() == 0) {
            this.setAuthPolicies(policyUri);
        } else {
            this.setAuthPolicies(String.valueOf(policies) + " " + policyUri);
        }
    }

    public List<String> getAuthPoliciesList() {
        String policies = this.getParameterValue("auth_policies");
        if (policies != null) {
            return Arrays.asList(policies.split(" "));
        }
        return new ArrayList<String>();
    }

    public void setAuthAge(int seconds) {
        if (-1 == seconds) {
            this.set("auth_age", AUTH_AGE_UNKNOWN);
        } else {
            this.set("auth_age", Integer.toString(seconds));
        }
    }

    public int getAuthAge() {
        String authAge = this.getParameterValue("auth_age");
        if (authAge == null) {
            return -1;
        }
        if (AUTH_AGE_UNKNOWN.equals(authAge)) {
            return 0;
        }
        return Integer.parseInt(authAge);
    }

    public int getNistAuthLevel() {
        String level = this.getParameterValue("nist_auth_level");
        if (level != null && level.length() > 0) {
            return Integer.parseInt(level);
        }
        return -1;
    }

    public void setNistAuthLevel(int level) throws MessageException {
        if (level < 0 || level > 4) {
            throw new MessageException("Invalid NIST level: " + level);
        }
        this.set("nist_auth_level", Integer.toString(level));
    }

    private boolean isValid() {
        if (!this.parameters.hasParameter("auth_policies")) {
            LOG.warn((Object)"auth_policies is required in a PAPE response.");
            return false;
        }
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (PAPE_FIELDS.contains(paramName)) continue;
            LOG.warn((Object)("Invalid parameter name in PAPE response: " + paramName));
            return false;
        }
        return true;
    }
}

