/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.sreg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.sreg.SRegMessage;
import jp.sourceforge.tsukuyomi.openid.message.sreg.SRegRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRegResponse
extends SRegMessage {
    private static final Log LOG = LogFactory.getLog(SRegResponse.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> SREG_FIELDS = Arrays.asList("nickname", "email", "fullname", "dob", "gender", "postcode", "country", "language", "timezone");

    protected SRegResponse() {
        if (DEBUG) {
            LOG.debug((Object)"Created empty fetch response.");
        }
    }

    public static SRegResponse createFetchResponse() {
        return new SRegResponse();
    }

    protected SRegResponse(ParameterList params) {
        this.parameters = params;
    }

    public static SRegResponse createSRegResponse(ParameterList params) throws MessageException {
        SRegResponse resp = new SRegResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a SReg response");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created SReg response from parameter list:\n" + params));
        }
        return resp;
    }

    public static SRegResponse createSRegResponse(SRegRequest req, Map<String, String> userData) throws MessageException {
        SRegResponse resp = new SRegResponse();
        List<String> attributes = req.getAttributes();
        for (String attr : attributes) {
            String value = userData.get(attr);
            if (value == null) continue;
            resp.addAttribute(attr, value);
        }
        return resp;
    }

    public void addAttribute(String attr, String value) throws MessageException {
        this.parameters.set(new Parameter(attr, value));
        if (!SREG_FIELDS.contains(attr)) {
            throw new MessageException("Invalid attribute for SReg: " + attr);
        }
        if (DEBUG) {
            LOG.debug((Object)("Added new attribute to SReg response: " + attr + " value: " + value));
        }
    }

    public String getAttributeValue(String attr) {
        return this.getParameterValue(attr);
    }

    public List<String> getAttributeNames() {
        ArrayList<String> attributes = new ArrayList<String>();
        for (Parameter param : this.parameters.getParameters()) {
            attributes.add(param.getKey());
        }
        return attributes;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Parameter param : this.parameters.getParameters()) {
            String attr = param.getKey();
            attributes.put(attr, this.getAttributeValue(attr));
        }
        return attributes;
    }

    private boolean isValid() {
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (SREG_FIELDS.contains(paramName)) continue;
            LOG.warn((Object)("Invalid parameter name in SReg response: " + paramName));
            return false;
        }
        return true;
    }
}

