/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.rp.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.crypto.spec.DHParameterSpec;
import jp.sourceforge.tsukuyomi.openid.OpenIDException;
import jp.sourceforge.tsukuyomi.openid.association.Association;
import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import jp.sourceforge.tsukuyomi.openid.association.AssociationSessionType;
import jp.sourceforge.tsukuyomi.openid.association.DiffieHellmanSession;
import jp.sourceforge.tsukuyomi.openid.discovery.Discovery;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryInformation;
import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierParser;
import jp.sourceforge.tsukuyomi.openid.http.HttpClientManager;
import jp.sourceforge.tsukuyomi.openid.message.AssociationError;
import jp.sourceforge.tsukuyomi.openid.message.AssociationRequest;
import jp.sourceforge.tsukuyomi.openid.message.AssociationResponse;
import jp.sourceforge.tsukuyomi.openid.message.AuthFailure;
import jp.sourceforge.tsukuyomi.openid.message.AuthImmediateFailure;
import jp.sourceforge.tsukuyomi.openid.message.AuthRequest;
import jp.sourceforge.tsukuyomi.openid.message.AuthSuccess;
import jp.sourceforge.tsukuyomi.openid.message.DirectError;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.VerifyRequest;
import jp.sourceforge.tsukuyomi.openid.message.VerifyResponse;
import jp.sourceforge.tsukuyomi.openid.op.NonceGenerator;
import jp.sourceforge.tsukuyomi.openid.op.RealmVerifier;
import jp.sourceforge.tsukuyomi.openid.rp.ConsumerAssociationStore;
import jp.sourceforge.tsukuyomi.openid.rp.NonceVerifier;
import jp.sourceforge.tsukuyomi.openid.rp.RelayParty;
import jp.sourceforge.tsukuyomi.openid.rp.RelayPartyException;
import jp.sourceforge.tsukuyomi.openid.rp.VerificationResult;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayPartyImpl
implements RelayParty {
    private static final Log LOG = LogFactory.getLog(RelayPartyImpl.class);
    public static final boolean DEBUG = LOG.isDebugEnabled();
    private Discovery discovery;
    private Association _privateAssociation;
    private boolean _allowStateless = true;
    private AssociationSessionType _prefAssocSessEnc;
    private int _maxAssocAttempts = 4;
    private int _failedAssocExpire = 300;
    private boolean _allowNoEncHttpSess = false;
    private DHParameterSpec _dhParams = DiffieHellmanSession.getDefaultParameter();
    private NonceGenerator consumerNonceGenerator;
    private HttpClientManager httpClientManager;
    private RealmVerifier _realmVerifier;
    private AssociationSessionType _minAssocSessEnc = AssociationSessionType.NO_ENCRYPTION_SHA1MAC;
    private ConsumerAssociationStore associations;
    private boolean _immediateAuth = false;
    private NonceVerifier nonceVerifier;

    public RelayPartyImpl() throws RelayPartyException {
        this._realmVerifier = new RealmVerifier();
        this._prefAssocSessEnc = Association.isHmacSha256Supported() ? AssociationSessionType.DH_SHA256 : AssociationSessionType.DH_SHA1;
        try {
            this._privateAssociation = Association.generate(this._prefAssocSessEnc.getAssociationType(), "", 0);
        }
        catch (AssociationException e) {
            throw new RelayPartyException("Cannot initialize private association, needed for consumer nonces.");
        }
    }

    @Override
    public List<DiscoveryInformation> discover(String identifier) throws DiscoveryException, IdentifierException {
        Identifier id = IdentifierParser.parse(identifier);
        return this.discovery.discover(id);
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    @Override
    public DiscoveryInformation associate(List<DiscoveryInformation> discoveries) {
        DiscoveryInformation discovered;
        Iterator<DiscoveryInformation> itr = discoveries.iterator();
        for (int attemptsLeft = this._maxAssocAttempts; itr.hasNext() && attemptsLeft > 0; attemptsLeft -= this.associate(discovered, attemptsLeft)) {
            discovered = itr.next();
            Association assoc = this.associations.load(discovered.getIdpEndpoint().toString());
            if (assoc == null || " ".equals(assoc.getHandle())) continue;
            return discovered;
        }
        if (discoveries.size() > 0) {
            DiscoveryInformation d0 = discoveries.get(0);
            LOG.warn((Object)("Association failed; using first entry: " + d0.getIdpEndpoint()));
            return d0;
        }
        LOG.error((Object)"Association attempt, but no discovey endpoints provided.");
        return null;
    }

    private int associate(DiscoveryInformation discovered, int maxAttempts) {
        if (this._maxAssocAttempts == 0) {
            return 0;
        }
        URL idpUrl = discovered.getIdpEndpoint();
        String idpEndpoint = idpUrl.toString();
        LOG.info((Object)("Trying to associate with " + idpEndpoint + " attempts left: " + maxAttempts));
        Association a = this.associations.load(idpEndpoint);
        if (a != null && a.getHandle() != null) {
            LOG.info((Object)"Found an existing association.");
            return 0;
        }
        String handle = " ";
        HashSet<AssociationSessionType> requests = new HashSet<AssociationSessionType>();
        if (discovered.isVersion2()) {
            requests.add(AssociationSessionType.NO_ENCRYPTION_SHA1MAC);
            requests.add(AssociationSessionType.NO_ENCRYPTION_SHA256MAC);
            requests.add(AssociationSessionType.DH_SHA1);
            requests.add(AssociationSessionType.DH_SHA256);
        } else {
            requests.add(AssociationSessionType.NO_ENCRYPTION_COMPAT_SHA1MAC);
            requests.add(AssociationSessionType.DH_COMPAT_SHA1);
        }
        if (this._prefAssocSessEnc.isVersion2() == discovered.isVersion2()) {
            requests.add(this._prefAssocSessEnc);
        }
        Stack<AssociationRequest> reqStack = new Stack<AssociationRequest>();
        for (AssociationSessionType type : requests) {
            AssociationRequest newReq = this.createAssociationRequest(type, idpUrl);
            if (newReq == null) continue;
            reqStack.push(newReq);
        }
        int attemptsLeft = maxAttempts;
        HashSet<AssociationSessionType> alreadyTried = new HashSet<AssociationSessionType>();
        while (attemptsLeft > 0 && !reqStack.empty()) {
            try {
                AssociationRequest newReq;
                --attemptsLeft;
                AssociationRequest assocReq = (AssociationRequest)reqStack.pop();
                if (DEBUG) {
                    LOG.debug((Object)("Trying association type: " + assocReq.getType()));
                }
                if (alreadyTried.contains(assocReq.getType())) {
                    if (!DEBUG) continue;
                    LOG.debug((Object)"Already tried.");
                    continue;
                }
                alreadyTried.add(assocReq.getType());
                ParameterList respParams = new ParameterList();
                int status = this.call(idpEndpoint, assocReq, respParams);
                if (status == 200) {
                    AssociationResponse assocResp = AssociationResponse.createAssociationResponse(respParams);
                    Association assoc = assocResp.getAssociation(assocReq.getDHSess());
                    handle = assoc.getHandle();
                    AssociationSessionType respType = assocResp.getType();
                    if (respType.equals(assocReq.getType()) || !discovered.isVersion2() && respType.getHAlgorithm() == null && this.createAssociationRequest(respType, idpUrl) != null) {
                        this.associations.save(idpEndpoint, assoc);
                        LOG.info((Object)("Associated with " + discovered.getIdpEndpoint() + " handle: " + assoc.getHandle()));
                        break;
                    }
                    LOG.info((Object)"Discarding, not matching consumer criteria");
                    continue;
                }
                if (status != 400) continue;
                LOG.info((Object)"Association attempt failed.");
                AssociationError assocErr = AssociationError.createAssociationError(respParams);
                AssociationSessionType idpType = AssociationSessionType.create(assocErr.getSessionType(), assocErr.getAssocType());
                if (alreadyTried.contains(idpType) || (newReq = this.createAssociationRequest(idpType, idpUrl)) == null) continue;
                if (DEBUG) {
                    LOG.debug((Object)("Retrieved association type from the association error: " + newReq.getType()));
                }
                reqStack.push(newReq);
            }
            catch (OpenIDException e) {
                LOG.error((Object)"Error encountered during association attempt.", (Throwable)e);
            }
        }
        if (" ".equals(handle) && this._failedAssocExpire > 0) {
            this.associations.save(idpEndpoint, Association.getFailedAssociation(this._failedAssocExpire));
        }
        return maxAttempts - attemptsLeft;
    }

    private AssociationRequest createAssociationRequest(AssociationSessionType type, URL idpUrl) {
        block7: {
            try {
                if (!this._minAssocSessEnc.isBetter(type)) break block7;
                return null;
            }
            catch (OpenIDException e) {
                LOG.error((Object)"Error trying to create association request.", (Throwable)e);
                return null;
            }
        }
        AssociationRequest assocReq = null;
        if (type.getHAlgorithm() != null) {
            DiffieHellmanSession dhSess = DiffieHellmanSession.create(type, this._dhParams);
            if (DiffieHellmanSession.isDhSupported(type) && Association.isHmacSupported(type.getAssociationType())) {
                assocReq = AssociationRequest.createAssociationRequest(type, dhSess);
            }
        } else if ((this._allowNoEncHttpSess || idpUrl.getProtocol().equals("https")) && Association.isHmacSupported(type.getAssociationType())) {
            assocReq = AssociationRequest.createAssociationRequest(type);
        }
        return assocReq;
    }

    private int call(String url, Message request, ParameterList response) throws MessageException {
        int responseCode = -1;
        PostMethod post = new PostMethod(url);
        try {
            try {
                post.setRequestEntity((RequestEntity)new StringRequestEntity(request.wwwFormEncoding(), "application/x-www-form-urlencoded", "UTF-8"));
                if (DEBUG) {
                    LOG.debug((Object)("Performing HTTP POST on " + url));
                }
                HttpClient httpClient = this.httpClientManager.getHttpClient();
                responseCode = httpClient.executeMethod((HttpMethod)post);
                String postResponse = post.getResponseBodyAsString();
                response.copyOf(ParameterList.createFromKeyValueForm(postResponse));
                if (DEBUG) {
                    LOG.debug((Object)("Retrived response:\n" + postResponse));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Error talking to " + url + " response code: " + responseCode), (Throwable)e);
                post.releaseConnection();
            }
        }
        finally {
            post.releaseConnection();
        }
        return responseCode;
    }

    @Override
    public AuthRequest authenticate(DiscoveryInformation discovered, String returnToUrl) throws MessageException, RelayPartyException {
        return this.authenticate(discovered, returnToUrl, returnToUrl);
    }

    public AuthRequest authenticate(DiscoveryInformation discovered, String returnToUrl, String realm) throws MessageException, RelayPartyException {
        if (discovered == null) {
            throw new RelayPartyException("Authentication cannot continue: no discovery information provided.");
        }
        this.associate(discovered, this._maxAssocAttempts);
        Association assoc = this.associations.load(discovered.getIdpEndpoint().toString());
        String handle = assoc != null ? assoc.getHandle() : " ";
        String claimedId = discovered.hasClaimedIdentifier() ? discovered.getClaimedIdentifier().getIdentifier() : "http://specs.openid.net/auth/2.0/identifier_select";
        String delegate = claimedId;
        if (discovered.hasDelegateIdentifier()) {
            delegate = discovered.getDelegateIdentifier();
        }
        if (!this._allowStateless && " ".equals(handle)) {
            throw new RelayPartyException("Authentication cannot be performed: no association available and stateless mode is disabled");
        }
        LOG.info((Object)("Creating authentication request for OP-endpoint: " + discovered.getIdpEndpoint() + " claimedID: " + claimedId + " OP-specific ID: " + delegate));
        AuthRequest authReq = AuthRequest.createAuthRequest(claimedId, delegate, !discovered.isVersion2(), returnToUrl, handle, realm, this._realmVerifier);
        authReq.setOPEndpoint(discovered.getIdpEndpoint());
        if (!discovered.isVersion2()) {
            authReq.setReturnTo(this.insertConsumerNonce(authReq.getReturnTo()));
        }
        if (!"http://specs.openid.net/auth/2.0/identifier_select".equals(claimedId)) {
            authReq.setImmediate(this._immediateAuth);
        }
        if (!authReq.isValid()) {
            throw new MessageException("Invalid AuthRequest: " + authReq.wwwFormEncoding());
        }
        return authReq;
    }

    public String insertConsumerNonce(String returnTo) {
        String nonce = this.consumerNonceGenerator.next();
        returnTo = String.valueOf(returnTo) + (returnTo.indexOf(63) != -1 ? (char)'&' : '?');
        try {
            returnTo = String.valueOf(returnTo) + "openid.rpnonce=" + URLEncoder.encode(nonce, "UTF-8");
            returnTo = String.valueOf(returnTo) + "&openid.rpsig=" + URLEncoder.encode(this._privateAssociation.sign(returnTo), "UTF-8");
            LOG.info((Object)"Inserted consumer nonce.");
            if (DEBUG) {
                LOG.debug((Object)("return_to:" + returnTo));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error inserting consumre nonce.", (Throwable)e);
            return null;
        }
        return returnTo;
    }

    public void setConsumerNonceGenerator(NonceGenerator consumerNonceGenerator) {
        this.consumerNonceGenerator = consumerNonceGenerator;
    }

    @Override
    public VerificationResult verify(String receivingUrl, ParameterList response, DiscoveryInformation discovered) throws MessageException, DiscoveryException, AssociationException, IdentifierException {
        VerificationResult result = new VerificationResult();
        LOG.info((Object)"Verifying authentication response...");
        if ("cancel".equals(response.getParameterValue("openid.mode"))) {
            result.setAuthResponse(AuthFailure.createAuthFailure(response));
            LOG.info((Object)"Received auth failure.");
            return result;
        }
        if ("setup_needed".equals(response.getParameterValue("openid.mode")) || "id_res".equals(response.getParameterValue("openid.mode")) && response.hasParameter("openid.user_setup_url")) {
            AuthImmediateFailure fail = AuthImmediateFailure.createAuthImmediateFailure(response);
            result.setAuthResponse(fail);
            result.setIdpSetupUrl(fail.getUserSetupUrl());
            LOG.info((Object)"Received auth immediate failure.");
            return result;
        }
        AuthSuccess authResp = AuthSuccess.createAuthSuccess(response);
        LOG.info((Object)"Received positive auth response.");
        if (!authResp.isValid()) {
            throw new MessageException("Invalid Authentication Response: " + authResp.wwwFormEncoding());
        }
        result.setAuthResponse(authResp);
        if (!this.verifyReturnTo(receivingUrl, authResp)) {
            result.setStatusMsg("Return_To URL verification failed.");
            LOG.error((Object)"Return_To URL verification failed.");
            return result;
        }
        if ((discovered = this.verifyDiscovered(authResp, discovered)) == null || !discovered.hasClaimedIdentifier()) {
            result.setStatusMsg("Discovered information verification failed.");
            LOG.error((Object)"Discovered information verification failed.");
            return result;
        }
        if (!this.verifyNonce(authResp, discovered)) {
            result.setStatusMsg("Nonce verificaton failed.");
            LOG.error((Object)"Nonce verificaton failed.");
            return result;
        }
        return this.verifySignature(authResp, discovered, result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyReturnTo(String receivingUrl, AuthSuccess response) {
        StringBuffer returnToPath;
        URL returnTo;
        URL receiving;
        if (DEBUG) {
            LOG.debug((Object)("Verifying return URL; receiving: " + receivingUrl + "\nmessage: " + response.getReturnTo()));
        }
        try {
            receiving = new URL(receivingUrl);
            returnTo = new URL(response.getReturnTo());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Invalid return URL.", (Throwable)e);
            return false;
        }
        StringBuffer receivingPath = new StringBuffer(receiving.getPath());
        if (receivingPath.length() > 0 && receivingPath.charAt(receivingPath.length() - 1) != '/') {
            receivingPath.append('/');
        }
        if ((returnToPath = new StringBuffer(returnTo.getPath())).length() > 0 && returnToPath.charAt(returnToPath.length() - 1) != '/') {
            returnToPath.append('/');
        }
        if (!(receiving.getProtocol().equals(returnTo.getProtocol()) && receiving.getAuthority().equals(returnTo.getAuthority()) && receivingPath.toString().equals(returnToPath.toString()))) {
            if (!DEBUG) return false;
            LOG.debug((Object)"Return URL schema, authority or path verification failed.");
            return false;
        }
        try {
            List<String> returnToValues;
            List<String> receivingValues;
            Map<String, List<String>> returnToParams = this.extractQueryParams(returnTo);
            Map<String, List<String>> receivingParams = this.extractQueryParams(receiving);
            if (returnToParams == null) {
                return true;
            }
            if (receivingParams == null) {
                if (!DEBUG) return false;
                LOG.debug((Object)"Return URL query parameters verification failed.");
                return false;
            }
            Iterator<Map.Entry<String, List<String>>> iterator = returnToParams.entrySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                Map.Entry<String, List<String>> returnToParam = iterator.next();
                receivingValues = receivingParams.get(returnToParam.getKey());
                returnToValues = returnToParam.getValue();
            } while (receivingValues != null && receivingValues.size() == returnToValues.size() && receivingValues.containsAll(returnToValues));
            if (!DEBUG) return false;
            LOG.debug((Object)"Return URL query parameters verification failed.");
            return false;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Error verifying return URL query parameters.", (Throwable)e);
            return false;
        }
    }

    public Map<String, List<String>> extractQueryParams(URL url) throws UnsupportedEncodingException {
        if (url.getQuery() == null) {
            return null;
        }
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        String[] stringArray = url.getQuery().split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            String keyValue = stringArray[n2];
            int equalPos = keyValue.indexOf("=");
            String string = key = equalPos > -1 ? URLDecoder.decode(keyValue.substring(0, equalPos), "UTF-8") : URLDecoder.decode(keyValue, "UTF-8");
            String value = equalPos <= -1 ? null : (equalPos + 1 > keyValue.length() ? "" : URLDecoder.decode(keyValue.substring(equalPos + 1), "UTF-8"));
            List existingValues = (List)paramsMap.get(key);
            if (existingValues == null) {
                ArrayList<String> newValues = new ArrayList<String>();
                newValues.add(value);
                paramsMap.put(key, newValues);
            } else {
                existingValues.add(value);
            }
            ++n2;
        }
        return paramsMap;
    }

    private VerificationResult verifySignature(AuthSuccess authResp, DiscoveryInformation discovered, VerificationResult result) throws AssociationException, MessageException {
        Identifier verifiedID;
        if (discovered == null || authResp == null) {
            LOG.error((Object)"Can't verify signature: null assertion or discovered information.");
            result.setStatusMsg("Can't verify signature: null assertion or discovered information.");
            return result;
        }
        String handle = authResp.getHandle();
        URL idp = discovered.getIdpEndpoint();
        Association assoc = this.associations.load(idp.toString(), handle);
        if (assoc != null) {
            LOG.info((Object)("Found association: " + assoc.getHandle() + " verifying signature locally..."));
            String text = authResp.getSignedText();
            String signature = authResp.getSignature();
            if (assoc.verifySignature(text, signature)) {
                result.setVerifiedId(discovered.getClaimedIdentifier());
                if (DEBUG) {
                    LOG.debug((Object)"Local signature verification succeeded.");
                }
            } else if (DEBUG) {
                LOG.debug((Object)"Local signature verification failed.");
            }
        } else {
            LOG.info((Object)"No association found, contacting the OP for direct verification...");
            VerifyRequest vrfy = VerifyRequest.createVerifyRequest(authResp);
            ParameterList responseParams = new ParameterList();
            int respCode = this.call(idp.toString(), vrfy, responseParams);
            if (200 == respCode) {
                VerifyResponse vrfyResp = VerifyResponse.createVerifyResponse(responseParams);
                if (vrfyResp.isValid() && vrfyResp.isSignatureVerified()) {
                    String invalidateHandle = vrfyResp.getInvalidateHandle();
                    if (invalidateHandle != null) {
                        this.associations.remove(idp.toString(), invalidateHandle);
                    }
                    result.setVerifiedId(discovered.getClaimedIdentifier());
                    if (DEBUG) {
                        LOG.debug((Object)("Direct signature verification succeeded with OP: " + idp));
                    }
                } else {
                    if (DEBUG) {
                        LOG.debug((Object)("Direct signature verification failed with OP: " + idp));
                    }
                    result.setStatusMsg("Direct signature verification failed.");
                }
            } else {
                DirectError err = DirectError.createDirectError(responseParams);
                if (DEBUG) {
                    LOG.debug((Object)("Error verifying signature with the OP: " + idp + " error message: " + err.keyValueFormEncoding()));
                }
                result.setStatusMsg("Error verifying signature with the OP: " + err.getErrorMsg());
            }
        }
        if ((verifiedID = result.getVerifiedId()) != null) {
            LOG.info((Object)("Verification succeeded for: " + verifiedID));
        } else {
            LOG.error((Object)("Verification failed for: null reason: " + result.getStatusMsg()));
        }
        return result;
    }

    private DiscoveryInformation verifyDiscovered(AuthSuccess authResp, DiscoveryInformation discovered) throws DiscoveryException, IdentifierException {
        if (authResp == null || authResp.getIdentity() == null) {
            LOG.info((Object)"Assertion is not about an identifier");
            return null;
        }
        if (authResp.isVersion2()) {
            return this.verifyDiscovered2(authResp, discovered);
        }
        return this.verifyDiscovered1(authResp, discovered);
    }

    private DiscoveryInformation verifyDiscovered1(AuthSuccess authResp, DiscoveryInformation discovered) throws DiscoveryException {
        String opSpecific;
        if (authResp == null || authResp.isVersion2() || authResp.getIdentity() == null || discovered == null || discovered.getClaimedIdentifier() == null || discovered.isVersion2()) {
            if (DEBUG) {
                LOG.debug((Object)"Discovered information doesn't match auth response / version");
            }
            return null;
        }
        String assertId = authResp.getIdentity();
        Identifier claimedId = discovered.getClaimedIdentifier();
        if (DEBUG) {
            LOG.debug((Object)("Verifying discovered information for OpenID1 assertion about ClaimedID: " + claimedId.getIdentifier()));
        }
        String string = opSpecific = discovered.hasDelegateIdentifier() ? discovered.getDelegateIdentifier() : claimedId.getIdentifier();
        if (opSpecific.equals(assertId)) {
            return discovered;
        }
        if (DEBUG) {
            LOG.debug((Object)"Identifier in the assertion doesn't match the one in the discovered information.");
        }
        return null;
    }

    private DiscoveryInformation verifyDiscovered2(AuthSuccess authResp, DiscoveryInformation discovered) throws DiscoveryException, IdentifierException {
        if (authResp == null || !authResp.isVersion2() || authResp.getIdentity() == null || authResp.getClaimed() == null) {
            if (DEBUG) {
                LOG.debug((Object)"Discovered information doesn't match auth response / version");
            }
            return null;
        }
        String assertId = authResp.getIdentity();
        Identifier respClaimed = IdentifierParser.parse(authResp.getClaimed());
        String respEndpoint = authResp.getOpEndpoint();
        if (DEBUG) {
            LOG.debug((Object)("Verifying discovered information for OpenID2 assertion about ClaimedID: " + respClaimed.getIdentifier()));
        }
        if (discovered != null && discovered.hasClaimedIdentifier() && discovered.getClaimedIdentifier().equals(respClaimed)) {
            String opSpecific;
            String string = opSpecific = discovered.hasDelegateIdentifier() ? discovered.getDelegateIdentifier() : discovered.getClaimedIdentifier().getIdentifier();
            if (opSpecific.equals(assertId) && discovered.isVersion2() && discovered.getIdpEndpoint().toString().equals(respEndpoint)) {
                if (DEBUG) {
                    LOG.debug((Object)("ClaimedID in the assertion was previously discovered: " + respClaimed));
                }
                return discovered;
            }
        }
        DiscoveryInformation firstServiceMatch = null;
        if (DEBUG) {
            LOG.debug((Object)("Performing discovery on the ClaimedID in the assertion: " + respClaimed));
        }
        List<DiscoveryInformation> discoveries = this.discovery.discover(respClaimed);
        if (DEBUG) {
            LOG.debug((Object)"Looking for a service element to match the ClaimedID and OP endpoint in the assertion...");
        }
        for (DiscoveryInformation service : discoveries) {
            Association assoc;
            String opSpecific;
            if ("http://specs.openid.net/auth/2.0/server".equals(service.getVersion())) continue;
            String string = opSpecific = service.hasDelegateIdentifier() ? service.getDelegateIdentifier() : service.getClaimedIdentifier().getIdentifier();
            if (!opSpecific.equals(assertId) || !service.isVersion2() || !service.getIdpEndpoint().toString().equals(respEndpoint)) continue;
            if (firstServiceMatch == null) {
                if (DEBUG) {
                    LOG.debug((Object)("Found matching service: " + service));
                }
                firstServiceMatch = service;
            }
            if ((assoc = this.associations.load(service.getIdpEndpoint().toString(), authResp.getHandle())) == null) continue;
            if (DEBUG) {
                LOG.debug((Object)"Found existing association, not looking for another service endpoint.");
            }
            return service;
        }
        if (firstServiceMatch == null) {
            LOG.error((Object)"No service element found to match the ClaimedID / OP-endpoint in the assertion.");
        }
        return firstServiceMatch;
    }

    public boolean verifyNonce(AuthSuccess authResp, DiscoveryInformation discovered) {
        String nonce = authResp.getNonce();
        if (nonce == null) {
            nonce = this.extractConsumerNonce(authResp.getReturnTo());
        }
        if (nonce == null) {
            return false;
        }
        return this.nonceVerifier.seen(discovered.getIdpEndpoint().toString(), nonce) == 0;
    }

    public String extractConsumerNonce(String returnTo) {
        String[] params;
        URL returnToUrl;
        if (DEBUG) {
            LOG.debug((Object)"Extracting consumer nonce...");
        }
        String nonce = null;
        String signature = null;
        try {
            returnToUrl = new URL(returnTo);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Invalid return_to: " + returnTo), (Throwable)e);
            return null;
        }
        String query = returnToUrl.getQuery();
        String[] stringArray = params = query.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] keyVal = element.split("=", 2);
            try {
                if (keyVal.length == 2 && "openid.rpnonce".equals(keyVal[0])) {
                    nonce = URLDecoder.decode(keyVal[1], "UTF-8");
                    if (DEBUG) {
                        LOG.debug((Object)("Extracted consumer nonce: " + nonce));
                    }
                }
                if (keyVal.length == 2 && "openid.rpsig".equals(keyVal[0])) {
                    signature = URLDecoder.decode(keyVal[1], "UTF-8");
                    if (DEBUG) {
                        LOG.debug((Object)("Extracted consumer nonce signature: " + signature));
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)"Error extracting consumer nonce / signarure.", (Throwable)e);
                return null;
            }
            ++n2;
        }
        if (signature == null) {
            LOG.error((Object)"Null consumer nonce signature.");
            return null;
        }
        String signed = returnTo.substring(0, returnTo.indexOf("&openid.rpsig="));
        if (DEBUG) {
            LOG.debug((Object)("Consumer signed text:\n" + signed));
        }
        try {
            if (this._privateAssociation.verifySignature(signed, signature)) {
                LOG.info((Object)"Consumer nonce signature verified.");
                return nonce;
            }
            LOG.error((Object)"Consumer nonce signature failed.");
            return null;
        }
        catch (AssociationException e) {
            LOG.error((Object)"Error verifying consumer nonce signature.", (Throwable)e);
            return null;
        }
    }

    public void setNonceVerifier(NonceVerifier nonceVerifier) {
        this.nonceVerifier = nonceVerifier;
    }

    public void setAssociations(ConsumerAssociationStore associations) {
        this.associations = associations;
    }

    public HttpClientManager getHttpClientManager() {
        return this.httpClientManager;
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }
}

