/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.yadis;

import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisException;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisUrl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.xml.XRDS;

public class YadisResult {
    private static final Log LOG = LogFactory.getLog(YadisResult.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private XRDS xrds;
    private String contentType;
    private YadisUrl yadisUrl;
    private String normalizedUrl;
    private URL xrdsLocation;
    private int status = -1;
    private String statusMessage;
    private Throwable failureCause;
    public static final int UNDISCOVERED = -1;
    public static final int OK = 0;
    public static final int UNKNOWN_ERROR = 1;
    public static final int INVALID_URL = 2;
    public static final int INVALID_SCHEME = 3;
    public static final int HEAD_TRANSPORT_ERROR = 4;
    public static final int HEAD_INVALID_RESPONSE = 5;
    public static final int GET_ERROR = 6;
    public static final int GET_TRANSPORT_ERROR = 7;
    public static final int GET_INVALID_RESPONSE = 8;
    public static final int GET_NO_XRDS = 9;
    public static final int HTMLMETA_DOWNLOAD_ERROR = 10;
    public static final int HTMLMETA_INVALID_RESPONSE = 11;
    public static final int XRDS_DOWNLOAD_ERROR = 12;
    public static final int XRDS_PARSING_ERROR = 13;
    public static final int XRDS_SIZE_EXCEEDED = 14;

    public void setYadisUrl(YadisUrl url) {
        this.yadisUrl = url;
    }

    public YadisUrl getYadisUrl() {
        return this.yadisUrl;
    }

    public void setXrdsLocation(String xrdsLocation, int onFailError) throws YadisException {
        URL xrdsUrl = null;
        boolean validXrdsUrl = true;
        try {
            xrdsUrl = new URL(xrdsLocation);
        }
        catch (MalformedURLException e) {
            validXrdsUrl = false;
        }
        if (xrdsUrl == null || !validXrdsUrl || !xrdsUrl.getProtocol().equals("http") && !xrdsUrl.getProtocol().equals("https")) {
            throw new YadisException("A Yadis Resource Descriptor URL MUST be an absolute URL and it must be HTTP or HTTPS; found: " + xrdsLocation, onFailError);
        }
        if (DEBUG) {
            LOG.debug((Object)("Setting X-XRDS-Location for yadis result: " + xrdsLocation));
        }
        this.xrdsLocation = xrdsUrl;
    }

    public URL getXrdsLocation() {
        return this.xrdsLocation;
    }

    public void setXrds(XRDS xrds) {
        this.xrds = xrds;
    }

    public XRDS getXrds() {
        return this.xrds;
    }

    public String getNormalizedUrl() {
        return this.normalizedUrl;
    }

    public void setNormalizedUrl(String _normalizedUrl) {
        this.normalizedUrl = _normalizedUrl;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void setFailureCause(Throwable e) {
        this.failureCause = e;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public String dump() {
        StringBuffer dump = new StringBuffer();
        dump.append("YadisURL:").append(this.yadisUrl);
        dump.append("\nNormalizedURL:").append(this.normalizedUrl);
        dump.append("\nX-XRDS-Location:").append(this.xrdsLocation);
        dump.append("\nContent-type:").append(this.contentType);
        dump.append("\nXRDS:\n").append(this.xrds.dump());
        return dump.toString();
    }
}

