/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid;

import java.util.ResourceBundle;

/**
 * Tsukuyomi OpenID で使用する定数を定義するクラスです。
 * 
 * @author asuka
 * 
 */
public class Consts {
	/**
	 * メッセージリソースなどのキーに用いるプレフィックスです。
	 */
	public static final String KEY_PREFIX = "jp.sourceforge.tsukuyomi.openid.";

	/**
	 * Tsukuyomi OpenID 内で使用するメッセージのリソースバンドルです。
	 */
	public static final ResourceBundle BUNDLE =
		ResourceBundle.getBundle("jp/sourceforge/tsukuyomi/openid/messages");

	/**
	 * ディスカバリー情報をセッションに保存しておくためのキーです。
	 */
	public static final String SN_DISCOVERED =
		"jp.sourceforge.tsukuyomi." + "openid.discovered";

	private Consts() {
		// 何もしない
	}
}
