/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid;

/**
 * OpenID に関するユーティリティクラスです。
 * 
 * @author asuka
 */
public class OpenID {
	private static final String OPENID2 =
		"http://specs.openid.net/auth/2.0/signon";
	private static final String OPENID2_OP =
		"http://specs.openid.net/auth/2.0/server";

	private OpenID() {
		// 何もしない
	}

	/**
	 * OpenID のバージョン表記からバージョン 2 かどうかを取得します。
	 * 
	 * @param version
	 *            バージョン表記
	 * @return バージョン 2 の場合 true
	 * @see OpenIDConsumer#associate()
	 */
	public static boolean isVersion2(String version) {
		if (version == null || version.length() == 0) {
			return false;
		}

		return OPENID2.equals(version) || OPENID2_OP.equals(version);
	}
}
