/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid;

/**
 * OpenID コンシューマに対するインタフェースです。
 * 
 * @author asuka
 */
public interface OpenIDConsumer {
	/**
	 * OpenID Identifier で OpenID プロバイダを探しに行った際、OpenID プロバイダを取得できるかを調べます。
	 * 
	 * @param identifier
	 *            OpenID Identifier
	 * @return 取得できた場合 true
	 */
	boolean findProvider(String identifier);

	/**
	 * アソシエーション確立を行います。
	 * 
	 * @return 認証サーバが要求する OpenID のバージョン
	 */
	String associate();

	/**
	 * 認証リクエストを取得します。
	 * 
	 * @return 認証リクエスト
	 */
	AuthenticationRequest getAuthenticationRequest();

	/**
	 * 認証リクエストを取得します。
	 * 
	 * @param returnTo
	 *            OP からの戻り先のパス
	 * @return 認証リクエスト
	 * @since 0.2.1
	 */
	AuthenticationRequest getAuthenticationRequest(String returnTo);

	/**
	 * 認証応答結果に対するベリファイを行います。
	 * 
	 * @return ベリファイに成功した場合、ベリファイされた OpenID Identifier。失敗した場合は null
	 */
	String verify();

	/**
	 * プロバイダに対してリクエストを送るまでの一連の処理を行います。
	 */
	void request();

	/**
	 * プロバイダに対してリクエストを送るまでの一連の処理を行います。
	 * 
	 * @param returnTo
	 *            戻り先パス
	 */
	void request(String returnTo);

	/**
	 * 認証応答結果に対するベリファイを行います。
	 * 
	 * @param requestURI
	 *            リクエスト URI
	 * @return ベリファイに成功した場合、ベリファイされた OpenID Identifier。失敗した場合は null
	 * @since 0.2.1
	 */
	String verify(String requestURI);

	/**
	 * 認証応答結果に対するベリファイを行います。リクエスト URI
	 * の検証は、内部で取得していますが、意図した値を取得しないようであれば呼び出し側で取得し、{@link #verify(String)}
	 * を使用してください。
	 * 
	 * @return ベリファイに成功した場合、ベリファイされた OpenID Identifier。失敗した場合は null
	 */
	String verifyRequest();
}
