/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.discovery;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Holds information obtained by performing HTML discovery on an URL.
 */
public class HtmlResult {
	private UrlIdentifier claimedId;
	private URL idp1Endpoint;
	private String delegate1;
	private URL idp2Endpoint;
	private String delegate2;

	/**
	 * Constructs an empty HtmlResult object.
	 */
	public HtmlResult() {

	}

	/**
	 * Sets the claimed identifier.
	 */
	public void setClaimed(UrlIdentifier claimed) {
		this.claimedId = claimed;
	}

	/**
	 * Gets the claimed identifier.
	 */
	public UrlIdentifier getClaimedId() {
		return this.claimedId;
	}

	public void setEndpoint1(String idp1Endpoint) throws DiscoveryException {
		URL url;
		try {
			url = new URL(idp1Endpoint);

			this.idp1Endpoint = url;
		} catch (MalformedURLException e) {
			throw new DiscoveryException("Invalid openid.server URL: "
				+ idp1Endpoint);
		}

	}

	public URL getIdp1Endpoint() {
		return this.idp1Endpoint;
	}

	public void setDelegate1(String delegate1) {
		this.delegate1 = delegate1;
	}

	public String getDelegate1() {
		return this.delegate1;
	}

	public void setEndpoint2(String idp2Endpoint) throws DiscoveryException {
		URL url;
		try {
			url = new URL(idp2Endpoint);

			this.idp2Endpoint = url;

		} catch (MalformedURLException e) {
			throw new DiscoveryException("Invalid openid2.provider URL: "
				+ idp2Endpoint);
		}

	}

	public URL getIdp2Endpoint() {
		return this.idp2Endpoint;
	}

	public void setDelegate2(String delegate2) {
		this.delegate2 = delegate2;
	}

	public String getDelegate2() {
		return this.delegate2;
	}

	@Override
	public String toString() {
		return "ClaimedID:"
			+ this.claimedId
			+ (this.idp2Endpoint != null ? "\nOpenID2-endpoint:"
				+ this.idp2Endpoint.toString() : "")
			+ (this.delegate2 != null
				? "\nOpenID2-localID:" + this.delegate2
				: "")
			+ (this.idp1Endpoint != null ? "\nOpenID1-endpoint:"
				+ this.idp1Endpoint.toString() : "")
			+ (this.delegate1 != null
				? "\nOpenID1-delegate:" + this.delegate1
				: "");
	}
}
