/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.discovery;

import org.openxri.XRI;

public class XriIdentifier implements Identifier {
	private static final long serialVersionUID = -215270939966252358L;

	private XRI xriIdentifier;

	public XriIdentifier(String identifier) {
		// should be in the canonical form
		xriIdentifier = new XRI(identifier);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}

		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		final XriIdentifier that = (XriIdentifier) o;

		// workaround, XRI should properly implement equals
		String thisNormalForm = this.xriIdentifier.toIRINormalForm();
		String thatNormalForm = that.xriIdentifier.toIRINormalForm();

		return thisNormalForm.equals(thatNormalForm);
	}

	@Override
	public int hashCode() {
		return xriIdentifier.hashCode();
	}

	public String getIdentifier() {
		return xriIdentifier.toString();
	}

	public XRI getXriIdentifier() {
		return xriIdentifier;
	}
}
