/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.http.impl;

import jp.sourceforge.tsukuyomi.openid.http.HttpClientManager;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.lang.StringUtils;

public class HttpClientManagerImpl implements HttpClientManager {
	/**
	 * Maximum number of redirects to be followed for the HTTP calls.
	 */
	private int maxRedirects = 10;

	/**
	 * Maximum length (in bytes) to read when parsing a HTML response.
	 */
	private int maxHtmlSize = 100000;

	/**
	 * Maximum size in bytes for the XRDS document.
	 */
	private int maxXmlSize = 100000;

	/**
	 * HTTP connect timeout, in milliseconds.
	 */
	private int connTimeout = 3000;

	/**
	 * HTTP socket (read) timeout, in milliseconds.
	 */
	private int socketTimeout = 5000;

	private int proxyPort = -1;
	private String proxyPassword;
	private String proxyHostName;
	private String proxyUserName;

	public HttpClient getHttpClient() {
		return getHttpClient(true);
	}

	public int getMaxRedirects() {
		return maxRedirects;
	}

	public void setMaxRedirects(int maxRedirects) {
		this.maxRedirects = maxRedirects;
	}

	public int getMaxHtmlSize() {
		return maxHtmlSize;
	}

	public void setMaxHtmlSize(int maxHtmlSize) {
		this.maxHtmlSize = maxHtmlSize;
	}

	public int getMaxXmlSize() {
		return maxXmlSize;
	}

	public void setMaxXmlSize(int maxXmlSize) {
		this.maxXmlSize = maxXmlSize;
	}

	public int getConnTimeout() {
		return connTimeout;
	}

	public void setConnTimeout(int connTimeout) {
		this.connTimeout = connTimeout;
	}

	public int getSocketTimeout() {
		return socketTimeout;
	}

	public void setSocketTimeout(int socketTimeout) {
		this.socketTimeout = socketTimeout;
	}

	public int getProxyPort() {
		return proxyPort;
	}

	public void setProxyPort(int proxyPort) {
		this.proxyPort = proxyPort;
	}

	public String getProxyPassword() {
		return proxyPassword;
	}

	public void setProxyPassword(String proxyPassword) {
		this.proxyPassword = proxyPassword;
	}

	public String getProxyHostName() {
		return proxyHostName;
	}

	public void setProxyHostName(String proxyHostName) {
		this.proxyHostName = proxyHostName;
	}

	public String getProxyUserName() {
		return proxyUserName;
	}

	public void setProxyUserName(String proxyUserName) {
		this.proxyUserName = proxyUserName;
	}

	public HttpClient getHttpClient(Boolean allowCircularRedirects) {
		HttpClient client =
			new HttpClient(new MultiThreadedHttpConnectionManager());

		client.getParams().setParameter(
			"http.protocol.max-redirects",
			maxRedirects);
		client.getParams().setParameter(
			"http.protocol.allow-circular-redirects",
			allowCircularRedirects);
		client.getParams().setSoTimeout(socketTimeout);
		client.getHttpConnectionManager().getParams().setConnectionTimeout(
			connTimeout);
		client.getParams().setParameter(
			"http.protocol.cookie-policy",
			CookiePolicy.IGNORE_COOKIES);

		HostConfiguration hostConf = client.getHostConfiguration();

		if (0 <= proxyPort && !StringUtils.isBlank(proxyHostName)) {
			hostConf.setProxy(proxyHostName, proxyPort);
		}
		if (!StringUtils.isBlank(proxyUserName)
			&& !StringUtils.isBlank(proxyPassword)) {
			// now set headers for auth
			AuthScope authScope =
				new AuthScope(
					AuthScope.ANY_HOST,
					AuthScope.ANY_PORT,
					AuthScope.ANY_REALM,
					AuthScope.ANY_SCHEME);
			client.getState().setProxyCredentials(
				authScope,
				new UsernamePasswordCredentials(proxyUserName, proxyPassword));
		}

		return client;
	}

}
