/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class AuthFailure extends Message {
	private static final Log LOG = LogFactory.getLog(AuthFailure.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	protected static final List<String> REQUIRED_FIELDS =
		Arrays.asList(new String[] { "openid.mode" });

	protected static final List<String> OPTIONAL_FIELDS =
		Arrays.asList(new String[] { "openid.ns" });

	public AuthFailure(boolean compatibility, String returnTo) {
		set("openid.mode", MODE_CANCEL);

		if (!compatibility) {
			set("openid.ns", OPENID2_NS);
		}

		destinationUrl = returnTo;
	}

	protected AuthFailure(ParameterList params) {
		super(params);
	}

	public static AuthFailure createAuthFailure(ParameterList params)
			throws MessageException {
		AuthFailure fail = new AuthFailure(params);

		if (!fail.isValid()) {
			throw new MessageException(
				"Invalid set of parameters for the requested message type");
		}

		if (DEBUG) {
			LOG.debug("Retrieved auth failure from message parameters:\n"
				+ fail.keyValueFormEncoding());
		}

		return fail;
	}

	@Override
	public List<String> getRequiredFields() {
		return REQUIRED_FIELDS;
	}

	public boolean isVersion2() {
		return hasParameter("openid.ns")
			&& OPENID2_NS.equals(getParameterValue("openid.ns"));
	}

	@Override
	public boolean isValid() {
		if (!super.isValid()) {
			return false;
		}

		return MODE_CANCEL.equals(getParameterValue("openid.mode"));
	}
}
