/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.message;

/**
 * Interface for building OpenID extensions.
 * <p>
 * Classes that implement this interface should provide a default constructor
 * and register their Type URIs with the MessageExtensionFactory.
 * 
 * @see MessageExtensionFactory Message
 * @author Marius Scurtescu, Johnny Bufu
 */
public interface MessageExtension {
	/**
	 * Gets the TypeURI that identifies a extension to the OpenID protocol.
	 */
	public String getTypeUri();

	/**
	 * Gets the extension-specific parameters.
	 * <p>
	 * Implementations MUST NOT prefix the parameter names with "openid.<extension_alias>".
	 * The alias is managed internally by the Message class, when a extension is
	 * attached to an OpenID messaage.
	 * 
	 * @see Message
	 */
	public ParameterList getParameters();

	/**
	 * Sets the extension-specific parameters.
	 * <p>
	 * Implementations MUST NOT prefix the parameter names with "openid.<extension_alias>".
	 * The alias is managed internally by the Message class, when a extension is
	 * attached to an OpenID messaage.
	 * 
	 * @param params
	 * @see Message
	 */
	public void setParameters(ParameterList params);

	/**
	 * Used by the core OpenID authentication implementation to learn whether an
	 * extension provies authentication services.
	 * <p>
	 * If the extension provides authentication services, the 'openid.identity'
	 * and 'openid.signed' parameters are optional.
	 * 
	 * @return True if the extension provides authentication services, false
	 *         otherwise.
	 */
	public boolean providesIdentifier();

}
