/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.message;

/**
 * Factory interface for creating message extension objects for a specific
 * message extension type URI.
 * 
 * @see MessageExtension
 * @see Message
 * @author Marius Scurtescu, Johnny Bufu
 */
public interface MessageExtensionFactory {

	/**
	 * Gets the extension type URI of the extension factory.
	 */
	public String getTypeUri();

	/**
	 * Builds a MessageExtension from a parameter list containing the
	 * extension-specific parameters.
	 * <p>
	 * The parameters MUST NOT contain the openid.<extension_alias> prefix.
	 * 
	 * @param parameterList
	 *            The extension parameters with the openid.<extension_alias>
	 *            prefix removed.
	 * @param isRequest
	 *            Indicates whether the parameters were extracted from an openid
	 *            request (true), or from an openid response (false). This may
	 *            assist the factory implementation in determining what object
	 *            type to instantiate.
	 * @return MessageExtension implementation for the supplied extension
	 *         parameters.
	 */
	public MessageExtension getExtension(ParameterList parameterList,
			boolean isRequest) throws MessageException;
}
