/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.op.impl;

import java.util.Date;

import jp.sourceforge.tsukuyomi.openid.op.NonceGenerator;
import jp.sourceforge.tsukuyomi.openid.util.InternetDateFormat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class IncrementalNonceGenerator implements NonceGenerator {
	private static final Log LOG =
		LogFactory.getLog(IncrementalNonceGenerator.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	private String timestamp = "";
	private int counter = 0;

	public synchronized String next() {
		String currentTimestamp = getCurrentTimpestamp();

		if (timestamp.equals(currentTimestamp)) {
			counter++;
		} else {
			timestamp = currentTimestamp;
			counter = 0;
		}

		String nonce = timestamp + Integer.toString(counter);

		if (DEBUG) {
			LOG.debug("Generated nonce: " + nonce);
		}

		return nonce;

	}

	private String getCurrentTimpestamp() {
		Date now = new Date();
		InternetDateFormat dateFormat = new InternetDateFormat();

		return dateFormat.format(now);
	}
}
