/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.rp;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public interface NonceVerifier {
	/**
	 * This noce is valid and it was not seen before. Nonce should be accepted.
	 */
	public static final int OK = 0;

	/**
	 * The nonce was seen before. Nonce should be rejected.
	 */
	public static final int SEEN = 1;

	/**
	 * The timestamp of the nonce is invalid, it cannot be parsed. Nonce should
	 * be rejected.
	 */
	public static final int INVALID_TIMESTAMP = 2;

	/**
	 * The timestamp of the nonce is too old and it is not tracked anymore.
	 * Nonce should be rejected.
	 */
	public static final int TOO_OLD = 3;

	/**
	 * Checks if a nonce was seen before. It also checks if the time stamp at
	 * the beginning of the noce is valid. Also, if old nonces are discarded the
	 * it should check if the time stamp for this noce is still valid.
	 * 
	 * @return {@link #OK} only if this nonce has a valid time stamp, the time
	 *         stamp did not age and the nonce was not seen before.
	 */
	public int seen(String idpUrl, String nonce);

	/**
	 * Returns the expiration timeout for nonces, in seconds
	 */
	public int getMaxAge();
}
