/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.rp;

import java.util.List;

import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryInformation;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.message.AuthRequest;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;

public interface RelayParty {
	List<DiscoveryInformation> discover(String identifier)
			throws DiscoveryException, IdentifierException;

	DiscoveryInformation associate(List<DiscoveryInformation> discoveries);

	AuthRequest authenticate(DiscoveryInformation discovered, String returnToUrl)
			throws MessageException, RelayPartyException;

	VerificationResult verify(String receivingUrl, ParameterList response,
			DiscoveryInformation discovered) throws MessageException,
			DiscoveryException, AssociationException, IdentifierException;
}
