/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.rp;

import jp.sourceforge.tsukuyomi.openid.OpenIDException;
import jp.sourceforge.tsukuyomi.openid.discovery.impl.DiscoveryImpl;
import jp.sourceforge.tsukuyomi.openid.discovery.impl.HtmlResolverImpl;
import jp.sourceforge.tsukuyomi.openid.http.impl.HttpClientManagerImpl;
import jp.sourceforge.tsukuyomi.openid.op.impl.IncrementalNonceGenerator;
import jp.sourceforge.tsukuyomi.openid.rp.impl.InMemoryConsumerAssociationStore;
import jp.sourceforge.tsukuyomi.openid.rp.impl.InMemoryNonceVerifier;
import jp.sourceforge.tsukuyomi.openid.rp.impl.RelayPartyImpl;
import jp.sourceforge.tsukuyomi.openid.yadis.impl.YadisResolverImpl;

public class RelayPartyFactory {
	public static RelayParty getInstance() throws OpenIDException {
		HttpClientManagerImpl hcm = new HttpClientManagerImpl();
		DiscoveryImpl discovery = new DiscoveryImpl();
		HtmlResolverImpl hr = new HtmlResolverImpl();
		YadisResolverImpl yr = new YadisResolverImpl();
		RelayPartyImpl rp = new RelayPartyImpl();
		IncrementalNonceGenerator ing = new IncrementalNonceGenerator();
		InMemoryNonceVerifier imnv = new InMemoryNonceVerifier(60);
		InMemoryConsumerAssociationStore imcas =
			new InMemoryConsumerAssociationStore();

		hr.setHttpClientManager(hcm);
		yr.setHttpClientManager(hcm);
		discovery.setHtmlResolver(hr);
		discovery.setYadisResolver(yr);

		rp.setDiscovery(discovery);
		rp.setConsumerNonceGenerator(ing);
		rp.setNonceVerifier(imnv);
		rp.setAssociations(imcas);

		return rp;
	}
}
