/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * A date formatter based on the Internet Date/Time format. This is defined in
 * section 5.6 of RFC 3339.
 * 
 * <p>
 * A date formatted in this way looks like:<br />
 * <b><code>2005-05-15T17:11:51Z</code></b>
 * 
 * @see <a href="http://www.ietf.org/rfc/rfc3339.txt">RFC 3339: section 5.6</a>
 * @author Marius Scurtescu, Johnny Bufu
 */
public class InternetDateFormat extends SimpleDateFormat {
	private static final long serialVersionUID = -3325703536403739212L;
	private static final Log LOG = LogFactory.getLog(InternetDateFormat.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
	public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");

	public InternetDateFormat() {
		super(PATTERN, Locale.US);
		setTimeZone(GMT_TIME_ZONE);
	}

	@Override
	public Date parse(String source) throws ParseException {
		Date date = super.parse(source.toUpperCase());

		if (DEBUG) {
			LOG.debug("Parsed " + source + " into Data object: " + date);
		}

		return date;
	}
}
