/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.openid.yadis;

import jp.sourceforge.tsukuyomi.openid.OpenIDException;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class YadisException extends OpenIDException {
	private static final long serialVersionUID = -907741473703579336L;

	private int statusCode;

	public YadisException(String message) {
		super(message);
		statusCode = YadisResult.UNKNOWN_ERROR;
	}

	public YadisException(String message, int status) {
		super(message);
		statusCode = status;
	}

	public YadisException(Throwable cause) {
		super(cause);
		statusCode = YadisResult.UNKNOWN_ERROR;
	}

	public YadisException(Throwable cause, int status) {
		super(cause);
		statusCode = status;
	}

	public YadisException(String message, Throwable cause) {
		super(message, cause);
		statusCode = YadisResult.UNKNOWN_ERROR;
	}

	public YadisException(String message, int status, Throwable cause) {
		super(message, cause);
		statusCode = status;
	}

	public int getStatusCode() {
		return statusCode;
	}
}
