/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.association.Association;
import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import jp.sourceforge.tsukuyomi.openid.association.AssociationSessionType;
import jp.sourceforge.tsukuyomi.openid.association.DiffieHellmanSession;
import jp.sourceforge.tsukuyomi.openid.message.AssociationRequest;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationResponse
extends Message {
    private static final Log LOG = LogFactory.getLog(AssociationResponse.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("assoc_type", "assoc_handle", "expires_in");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("ns", "session_type", "mac_key", "enc_mac_key", "dh_server_public");

    protected AssociationResponse(AssociationRequest assocReq, Association assoc) throws AssociationException {
        if (DEBUG) {
            LOG.debug((Object)("Creating association response, type: " + assocReq.getType() + " association handle: " + assoc.getHandle()));
        }
        if (assocReq.isVersion2()) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
        AssociationSessionType type = assocReq.getType();
        this.setType(type);
        this.setAssocHandle(assoc.getHandle());
        Long expiryIn = (assoc.getExpiry().getTime() - System.currentTimeMillis()) / 1000L;
        this.setExpire(expiryIn);
        if (type.getHAlgorithm() != null) {
            DiffieHellmanSession dhSess = DiffieHellmanSession.create(type, assocReq.getDhModulus(), assocReq.getDhGen());
            this.setPublicKey(dhSess.getPublicKey());
            this.setMacKeyEnc(dhSess.encryptMacKey(assoc.getMacKey().getEncoded(), assocReq.getDhPublicKey()));
        } else {
            this.setMacKey(new String(Base64.encodeBase64((byte[])assoc.getMacKey().getEncoded())));
        }
    }

    protected AssociationResponse(ParameterList params) {
        super(params);
    }

    public static AssociationResponse createAssociationResponse(AssociationRequest assocReq, Association assoc) throws MessageException, AssociationException {
        AssociationResponse resp = new AssociationResponse(assocReq, assoc);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created association response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public static AssociationResponse createAssociationResponse(ParameterList params) throws MessageException {
        AssociationResponse resp = new AssociationResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created association response from message parameters:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    private String getAssociationType() {
        return this.getParameterValue("assoc_type");
    }

    private String getSessionType() {
        return this.getParameterValue("session_type");
    }

    public void setType(AssociationSessionType type) {
        this.set("session_type", type.getSessionType());
        this.set("assoc_type", type.getAssociationType());
    }

    public AssociationSessionType getType() throws AssociationException {
        return AssociationSessionType.create(this.getSessionType(), this.getAssociationType(), !this.isVersion2());
    }

    public void setAssocHandle(String handle) {
        this.set("assoc_handle", handle);
    }

    public void setExpire(Long seconds) {
        this.set("expires_in", seconds.toString());
    }

    public void setMacKey(String key) {
        this.set("mac_key", key);
    }

    public void setPublicKey(String key) {
        this.set("dh_server_public", key);
    }

    public void setMacKeyEnc(String key) {
        this.set("enc_mac_key", key);
    }

    @Override
    public boolean isValid() {
        String macKey;
        AssociationSessionType type;
        if (!super.isValid()) {
            return false;
        }
        try {
            type = this.getType();
            if (type.isVersion2() ^ this.isVersion2()) {
                LOG.warn((Object)("Protocol verison mismatch between association session type: " + type + " and AssociationResponse message type."));
                return false;
            }
        }
        catch (AssociationException e) {
            LOG.error((Object)"Error verifying association response validity.", (Throwable)e);
            return false;
        }
        if (!this.isVersion2() && this.getAssociationType() == null) {
            LOG.warn((Object)"assoc_type cannot be omitted in OpenID1 responses");
            return false;
        }
        if (type.getHAlgorithm() != null) {
            if (!this.hasParameter("dh_server_public") || !this.hasParameter("enc_mac_key")) {
                LOG.warn((Object)"DH public key or encrypted MAC key missing.");
                return false;
            }
            macKey = this.getParameterValue("enc_mac_key");
        } else {
            if (!this.hasParameter("mac_key")) {
                LOG.warn((Object)"Missing MAC key.");
                return false;
            }
            macKey = this.getParameterValue("mac_key");
        }
        int macSize = Base64.decodeBase64((byte[])macKey.getBytes()).length * 8;
        if (macSize != type.getKeySize()) {
            LOG.warn((Object)("MAC key size: " + macSize + " doesn't match the association/session type: " + type));
            return false;
        }
        return true;
    }

    public Association getAssociation(DiffieHellmanSession dhSess) throws AssociationException {
        Association assoc;
        byte[] macKey;
        if (DEBUG) {
            LOG.debug((Object)"Retrieving MAC key from association response...");
        }
        String handle = this.getParameterValue("assoc_handle");
        int expiresIn = Integer.parseInt(this.getParameterValue("expires_in"));
        AssociationSessionType type = this.getType();
        if (type.getHAlgorithm() != null) {
            macKey = dhSess.decryptMacKey(this.getParameterValue("enc_mac_key"), this.getParameterValue("dh_server_public"));
            if (DEBUG) {
                LOG.debug((Object)("Decrypted MAC key (base64): " + new String(Base64.encodeBase64((byte[])macKey))));
            }
        } else {
            macKey = Base64.decodeBase64((byte[])this.getParameterValue("mac_key").getBytes());
            if (DEBUG) {
                LOG.debug((Object)("Unencrypted MAC key (base64): " + this.getParameterValue("mac_key")));
            }
        }
        if ("HMAC-SHA1".equals(type.getAssociationType())) {
            assoc = Association.createHmacSha1(handle, macKey, expiresIn);
        } else if ("HMAC-SHA256".equals(type.getAssociationType())) {
            assoc = Association.createHmacSha256(handle, macKey, expiresIn);
        } else {
            throw new AssociationException("Unknown association type: " + type);
        }
        if (DEBUG) {
            LOG.debug((Object)("Created association for handle: " + handle));
        }
        return assoc;
    }
}

