/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.sreg;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.sreg.SRegMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRegRequest
extends SRegMessage {
    private static final Log LOG = LogFactory.getLog(SRegRequest.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    protected SRegRequest() {
        if (DEBUG) {
            LOG.debug((Object)"Created empty SReg request.");
        }
    }

    public static SRegRequest createFetchRequest() {
        return new SRegRequest();
    }

    protected SRegRequest(ParameterList params) {
        this.parameters = params;
    }

    public static SRegRequest createSRegRequest(ParameterList params) throws MessageException {
        SRegRequest req = new SRegRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a SReg request");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created SReg request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String attr, boolean required) {
        Parameter newParam;
        String level = required ? "required" : "optional";
        Parameter levelParam = this.parameters.getParameter(level);
        if (levelParam == null) {
            newParam = new Parameter(level, this.multivalEncode(attr));
        } else {
            newParam = new Parameter(level, levelParam.getValue() + "," + this.multivalEncode(attr));
            this.parameters.removeParameters(level);
        }
        this.parameters.set(newParam);
        if (DEBUG) {
            LOG.debug((Object)("Added new attribute to SReg request: " + attr + " required: " + required));
        }
    }

    public List<String> getAttributes(boolean required) {
        ArrayList<String> attributes = new ArrayList<String>();
        String level = required ? "required" : "optional";
        Parameter param = this.parameters.getParameter(level);
        if (param != null) {
            String[] values;
            for (String element : values = param.getValue().split(",")) {
                String attr = this.multivalDecode(element);
                attributes.add(attr);
            }
        }
        return attributes;
    }

    public List<String> getAttributes() {
        List<String> attributes = this.getAttributes(true);
        attributes.addAll(this.getAttributes(false));
        return attributes;
    }

    public void setPolicyUrl(String policyUrl) throws MessageException {
        try {
            new URL(policyUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid policy_url: " + policyUrl);
        }
        if (DEBUG) {
            LOG.debug((Object)("Setting SReg request policy_url: " + policyUrl));
        }
        this.parameters.set(new Parameter("policy_url", policyUrl));
    }

    public String getUpdateUrl() {
        return this.parameters.hasParameter("policy_url") ? this.parameters.getParameterValue("policy_url") : null;
    }

    public boolean isValid() {
        if (!this.parameters.hasParameter("required") && !this.parameters.hasParameter("optional")) {
            LOG.warn((Object)"One of 'required' or 'optional' parameters must be present.");
            return false;
        }
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (paramName.equals("required") || paramName.equals("optional") || paramName.equals("policy_url")) continue;
            LOG.warn((Object)("Invalid parameter name in SReg request: " + paramName));
        }
        return true;
    }
}

