/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nihonsoft.turbosql.modules.pg.app.DatabaseNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.ServerNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.TableNodeObject;

public class DBTreeCellRenderer
extends DefaultTreeCellRenderer {
    private JTree tree;
    private URL[] urls;
    private ClassLoader urlClassLoader = this.getClass().getClassLoader();
    private URL serverNodeImageURL = this.urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/servernode.gif");
    private URL databaseNodeImageURL = this.urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/databasenode.gif");
    private URL tableNodeImageURL = this.urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/tablenode.gif");
    private URL viewNodeImageURL = this.urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/viewnode.gif");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object nodeObject = node.getUserObject();
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (nodeObject instanceof ServerNodeObject) {
                this.setDisabledIcon(new ImageIcon(this.serverNodeImageURL));
            } else if (nodeObject instanceof DatabaseNodeObject) {
                this.setDisabledIcon(new ImageIcon(this.databaseNodeImageURL));
            } else if (nodeObject instanceof TableNodeObject) {
                this.setDisabledIcon(new ImageIcon(this.tableNodeImageURL));
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (nodeObject instanceof ServerNodeObject) {
                this.setIcon(new ImageIcon(this.serverNodeImageURL));
            } else if (nodeObject instanceof DatabaseNodeObject) {
                this.setIcon(new ImageIcon(this.databaseNodeImageURL));
            } else if (nodeObject instanceof TableNodeObject) {
                this.setIcon(new ImageIcon(this.tableNodeImageURL));
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }
}

