/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.nihonsoft.turbosql.modules.pg.app.PostgreSQLDataObject;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.OriginalRowsContainer;

class ResultsModel
extends AbstractTableModel {
    String dataTypeMapper = "DefaultDataTypeMapper";
    String[] columnNames = new String[0];
    int[] columnTypes = new int[0];
    String[] columnTypeNames = new String[0];
    Vector dataRows = new Vector();
    boolean dataChanged = false;
    OriginalRowsContainer originalRows;
    String tableName;
    Object[] columnTypeArray;
    int originalRowsCount = 0;
    int columnCount = 0;

    ResultsModel() {
    }

    public void setResultSet(ResultSet results) {
        this.dataChanged = false;
        this.originalRows = null;
        if (results == null) {
            this.columnNames = new String[0];
            this.dataRows.clear();
            this.fireTableChanged(null);
            return;
        }
        try {
            int columns;
            ResultSetMetaData metadata = results.getMetaData();
            this.columnCount = columns = metadata.getColumnCount();
            this.columnNames = new String[columns];
            this.columnTypes = new int[columns];
            this.columnTypeNames = new String[columns];
            this.tableName = metadata.getTableName(1);
            int i = 0;
            while (i < columns) {
                this.columnNames[i] = metadata.getColumnLabel(i + 1);
                this.columnTypes[i] = metadata.getColumnType(i + 1);
                this.columnTypeNames[i] = metadata.getColumnTypeName(i + 1);
                ++i;
            }
            this.dataRows = PostgreSQLDataObject.processToDataRows(results);
            this.columnTypeArray = PostgreSQLDataObject.processToColumnTypeArray(this.columnTypes, this.columnTypeNames);
            this.originalRowsCount = this.dataRows.size();
            this.fireTableChanged(null);
        }
        catch (SQLException sqle) {
            System.err.println("error from ResultsModel.java: " + sqle);
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        if (this.dataRows == null) {
            return 0;
        }
        return this.dataRows.size();
    }

    public Object getValueAt(int row, int column) {
        return ((Object[])this.dataRows.elementAt(row))[column];
    }

    public String getColumnName(int column) {
        return this.columnNames[column] == null ? "No Names" : this.columnNames[column];
    }

    public void setValueAt(Object value, int row, int column) {
        this.dataChanged = true;
        if (this.originalRows == null) {
            this.originalRows = new OriginalRowsContainer();
        }
        int columnCount = ((Object[])this.dataRows.elementAt(row)).length;
        Object[] copyRows = new Object[columnCount];
        int i = 0;
        while (i < columnCount) {
            copyRows[i] = ((Object[])this.dataRows.elementAt(row))[i];
            ++i;
        }
        ((Object[])this.dataRows.elementAt((int)row))[column] = value;
        this.originalRows.add(row, copyRows, (Object[])this.dataRows.elementAt(row));
        this.fireTableChanged(null);
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int c) {
        return this.columnTypeArray[c].getClass();
    }

    public String getDataTypeMapper() {
        return this.dataTypeMapper;
    }

    public void setDataTypeMapper(String param_dataTypeMapper) {
        this.dataTypeMapper = param_dataTypeMapper;
    }

    public boolean save() {
        return false;
    }

    public boolean getDataChanged() {
        return this.dataChanged;
    }

    public void setDataChanged(boolean param_dataChanged) {
        this.dataChanged = param_dataChanged;
    }

    public OriginalRowsContainer getOriginalRows() {
        return this.originalRows;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getOriginalRowsCount() {
        return this.originalRowsCount;
    }

    public int getCurrentRowsCount() {
        return this.dataRows.size();
    }

    public void addNewRow() {
        Object[] emptyDataRow = new Object[this.columnCount];
        int i = 0;
        while (i < this.columnCount) {
            emptyDataRow[i] = null;
            ++i;
        }
        this.dataRows.add(emptyDataRow);
        this.fireTableChanged(null);
    }

    public Object[] getRowDataAtIndex(int index) {
        return (Object[])this.dataRows.get(index);
    }
}

