package org.nihonsoft.turbosql.modules.pg.app;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import java.sql.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import java.io.*;
import java.util.*;
import sun.io.ByteToCharConverter;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class DatabasePanel extends JPanel implements ActionListener, TreeSelectionListener
{
    private ClassLoader urlClassLoader;
    
    /*
    private String username = "postgres";
    private String password = "pg.test";
    private String serverIP = "192.168.168.235";
    private String serverPort = "5432";
     */
    
    private String username = "postgres";
    private String password = "";
    private String serverIP = "127.0.0.1";  // localhost
    private String serverPort = "5432";
    //private String url = "jdbc:postgresql://192.168.168.235:5432/testdb";
    private String url = "";
    
    private boolean isDBTreeLoaded = false;          // indicate whether the tree is loaded
    
    //private JTextField database = new JTextField(url);
    private JTextField serverIPInput = new JTextField(serverIP);
    private JTextField serverPortInput = new JTextField(serverPort);
    private JTextField usernameInput = new JTextField(username);
    private JPasswordField passwordInput = new JPasswordField(password);
    private JTextArea status = new JTextArea(3, 30);
    
    private DefaultMutableTreeNode serverNode;                  // Root node for the database tree
    private DefaultTreeModel dbTreeModel;                   // Model for the database metadata
    private JTree dbTree;                                   // Tree to display the metadata
    private JScrollPane treePane;                           // Scroll pane holding the tree
    
    //ResultsModel tableModel;                                // Model for table
    //private JTable table;                                   // Table holding table data
    JScrollPane infoPane;                                  // Scroll pane holding the table
    JEditorPane editorPane;                                 // editor pane for diplaying html
    
    private JScrollPane statusPane;                         // Scroll pane holding the status
    
    private String[] drivers = {"org.postgresql.Driver"};   // postgresql driver
    
    Connection conn;
    Statement statement;
    
    private PopupMenuContainer popupMenuContainer;
    
    private JPopupMenu defaultPanelPopup = new JPopupMenu("General");
    
    JButton connectButton = new JButton("Connect");
    JButton refreshButton = new JButton("Refresh");
    
    //------------------------------------------------------------------------
    // custom refresh listener
    ActionListener refreshListener = (ActionListener) new RefreshAction();
    //------------------------------------------------------------------------
        
    public DatabasePanel()
    {
        urlClassLoader = this.getClass().getClassLoader();
        /*
        super("Database Browser",
          true, //resizable
          true, //closable
          true, //maximizable
          true);//iconifiable // for frame.
         */
        
        //setBounds(0, 0, 400, 300); // for frame.
        //setDefaultCloseOperation(DISPOSE_ON_CLOSE); // for frame.
        //addWindowListener(new WindowHandler()); // nore more window
        //setBounds(
        setLayout(new BorderLayout());
        
        // Create labels for input fields
        JLabel serverIPLabel = new JLabel("Server IP: ");
        JLabel serverPortLabel = new JLabel("Port: ");
        JLabel usernameLabel = new JLabel("User ID: ", JLabel.RIGHT);
        //usernameLabel.setPreferredSize(dbURLLabel.getPreferredSize());        // Set same size
        JLabel passwordLabel = new JLabel("Password: ");
        
        //connectButton = new JButton();
        connectButton.addActionListener(this);
        
        //refreshButton = new JButton();
        refreshButton.addActionListener(this);
        
        // Box for database URL input
        Box dbPane = Box.createHorizontalBox();
        //dbPane.add(dbURLLabel);
        //dbPane.add(database);
        dbPane.add(serverIPLabel);
        dbPane.add(serverIPInput);
        dbPane.add(serverPortLabel);
        dbPane.add(serverPortInput);
        
        // Box for user ID and password input fields
        Box loginPane = Box.createHorizontalBox();
        loginPane.add(usernameLabel);
        loginPane.add(usernameInput);
        loginPane.add(passwordLabel);
        loginPane.add(passwordInput);
        
        Box buttonPane = Box.createVerticalBox();
        buttonPane.add(connectButton);
        buttonPane.add(refreshButton);
        
        Box inputPane2 = Box.createVerticalBox();
        inputPane2.add(dbPane);
        inputPane2.add(loginPane);
        
        Box inputPane = Box.createHorizontalBox();
        inputPane.add(inputPane2);
        inputPane.add(buttonPane);
        //getContentPane().add(inputPane, BorderLayout.NORTH); // for frame
        add(inputPane, BorderLayout.NORTH);
        
        // Add message area
        status.setText("Enter a database URL and/or press Enter");
        status.setEditable(false);              // No user input
        status.setLineWrap(true);               // Lines wrap
        status.setWrapStyleWord(true);          // on word boundaries
        status.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
        statusPane = new JScrollPane(status);
        statusPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        //getContentPane().add(statusPane, BorderLayout.SOUTH); // for frame
        add(statusPane, BorderLayout.SOUTH);
        
        // Create tree to go in left split pane
        serverNode = new DefaultMutableTreeNode("No database");
        dbTreeModel = new DefaultTreeModel(serverNode);
        dbTree = new JTree(dbTreeModel);
        treePane = new JScrollPane(dbTree);
        treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        treePane.setPreferredSize(new Dimension(400, 100));
        // Create table to go in right split pane
        /* we should not need this anymore
        tableModel = new ResultsModel();
        JTable table = new JTable(tableModel);
        table.setPreferredSize(new Dimension(800, 400));
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        infoPane = new JScrollPane(table);
         */
        String tempFileName;
        if(Locale.getDefault().getLanguage().equals("ja"))
            tempFileName = "dbwelcome_ja.html";
        else
            tempFileName = "dbwelcome.html";
        String fileContentsStr = getContentsStringFromFile("org/nihonsoft/turbosql/modules/pg/app/html/" + tempFileName, Locale.getDefault().getLanguage());
        //System.out.println(fileContentsStr);
        //System.out.println(System.getProperty("file.encoding"));
        //System.out.println(ByteToCharConverter.getDefault().getCharacterEncoding());
        //System.out.println(new InputStreamReader(System.in).getEncoding());
        
        /*
        try
        {
            editorPane = new JEditorPane(urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/html/text2.html"));
        } // try
        catch(IOException ioe)
        {
            System.out.println(ioe.getMessage());
        } // catch(IOException ioe)
         */
        editorPane = new JEditorPane();
        editorPane.addHyperlinkListener(new HyperlinkHandler());
        //editorPane.setVisible(true);
        //editorPane.setContentType("text/html");
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.setEditable(false);
        
        editorPane.setText(fileContentsStr);
        
        infoPane = new JScrollPane(editorPane);
        infoPane.setPreferredSize(new Dimension(500, 100));
        infoPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        //infoPane.add(editorPane);
        
        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                                              true,                     // Continuous relayout
                                              treePane,                 // Left pane content
                                              infoPane);               // Right pane content
        //getContentPane().add(splitPane, BorderLayout.CENTER); // for frame
        add(splitPane, BorderLayout.CENTER);
        splitPane.setDividerLocation(200);                              // Left pane 150 pixels wide
        
        // Add event listeners
        //database.addActionListener(this);
        serverIPInput.addActionListener(this);
        serverPortInput.addActionListener(this);
        usernameInput.addActionListener(this);
        passwordInput.addActionListener(this);
        dbTree.addTreeSelectionListener(this);
        
        dbTree.addMouseListener(new TreeMouseHandler());
        dbTree.addTreeSelectionListener(new TreeSelectionHandler());
        
        GenericMouseHandler mouseHandler = new GenericMouseHandler();
        editorPane.addMouseListener(mouseHandler);
        status.addMouseListener(mouseHandler);
        
        //pack(); //for frame                                // layout the components at their appropriate sizes
        
        setVisible(true);                       // Set window visible
        //show(); //for frame                                 // Display the window
        //database.requestFocus();                // Focus to the url input field
        passwordInput.requestFocus();
        
        defaultPanelPopup.add(new GenericAction("No action"));
        popupMenuContainer = new PopupMenuContainer();
        //add(popup);
        
        // Attempt to load all drivers
        for(int i = 0; i < drivers.length; i++)
            try
            {
                Class.forName(drivers[i]);
            }
            catch(ClassNotFoundException cnfe)
            {
                System.err.println(cnfe);
                status.setText("Driver load failed: " + cnfe.getMessage());
            } // catch(ClassNotFoundException cnfe)
        
    } // public DatabaseBrowse()
    
    /*
    public static void main(String[] args)
    {
        DatabasePanel theApp = new DatabasePanel();       // Create application object
    } // public static void main(String[] args)
     */
    
    public void openConnection()
    {
        try
        {
            if(conn != null)                         // If there is a connection close it
            {
                conn.close();
                
                // Rest the table data
                //tableModel.setResultSet(null);
                infoPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                
                // Rest the tree displaying metadata
                serverNode = new DefaultMutableTreeNode("No database");
                dbTreeModel.setRoot(serverNode);
                dbTree.setRootVisible(true);
                treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                dbTreeModel.reload();
            }
            
            // Now open the new connection
            
            conn = PostgreSQLDataObject.getConnection(url, username, password);
            //connection = DriverManager.getConnection(url, username, password);
            if(conn == null)
            {
                status.setText("Connection failed. Check that the hostname, port, user ID and password are correct, and that the postmaster is running with the -i flag, which enables TCP/IP networking.");
                return;
            } // if(conn == null)
            
            status.setText("Database connection established");
            //statement = connection.createStatement();                   // Create statement for query
            
            serverNode = new DefaultMutableTreeNode(new ServerNodeObject(serverIP, username, password, serverIP, serverPort));
            
            //dbNode = new DefaultMutableTreeNode(url);                   // Root node is URL
            dbTreeModel.setRoot(serverNode);                                // Set root in model
            dbTree.setCellRenderer(new DBTreeCellRenderer());
            PostgreSQLDataObject.buildServerNode(serverNode, conn);
            //setupTree(connection.getMetaData());                        // Set up tree with metadata
            
            treePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), url, TitledBorder.CENTER, TitledBorder.DEFAULT_POSITION));
            //---
            //dbTree.setRootVisible(false);                               // Now show the root node
            //---
            
            isDBTreeLoaded = true;                                      // indicate that tree is loaded
            
            dbTreeModel.reload();                                       // Get the tree redisplayed
            
            editorPane.setText("");                                     // clear the editorPane
             
            conn.close();           // close the connection if it is not necessary.
            
        } // try
        catch(SQLException sqle)
        {
            status.setText(sqle.getMessage());                          // Display first message
            do                                                          // loop through exceptions
            {
                System.err.println("Exception occured:\nMessage: " + sqle.getMessage());
                System.err.println("SQL state: " + sqle.getSQLState());
                System.err.println("Vendor code: " + sqle.getErrorCode() + "\n----------------------------");
            } // do
            while((sqle = sqle.getNextException()) != null);
        } // catch(SQLException sqle)
    } // public void openConnection()
    /*
    private void setupTree(DatabaseMetaData metadata) throws SQLException
    {
        String[] tableTypes = {"TABLE"};                                            // We want only tables
        ResultSet tables = metadata.getTables(null, null, null, tableTypes);         // Get the tables info
        
        String tableName;                                  // stores a table name
        DefaultMutableTreeNode tableNode;                   // Stores a tree node for a table
        while(tables.next())                                // For each table
        {
            tableName = tables.getString("TABLE_NAME");     // get the table name
            tableNode = new DefaultMutableTreeNode(tableName);
            dbNode.add(tableNode);                          // Add the node to the tree
            
            // Get all the columns for the current table
            ResultSet columnNames = metadata.getColumns(null, null, tableName, null);
            
            // Add nodes for the columns as children of the table node
            while(columnNames.next())
                tableNode.add(new DefaultMutableTreeNode(columnNames.getString("COLUMN_NAME")));
        } // while(tables.next())
    } // private void setupTree(DatabaseMetaData metadata)
     */
    
    public void refreshConnection()
    {
        TreePath[] visibleTreePaths = new TreePath[dbTree.getRowCount()];
        
        for(int i = 0; i < visibleTreePaths.length; i++)
        {
            visibleTreePaths[i] = dbTree.getPathForRow(i);
        } // for(int i = 0; i < visibleTreePaths.length; i++)
        
        //url = database.getText();                       // Get database URL
        url = PostgreSQLDataObject.getDefaultDBURL(serverIPInput.getText(), serverPortInput.getText());
        username = usernameInput.getText();                 // Get user ID
            
        char[] pw = passwordInput.getPassword();        // Get password
        if(pw != null)
            password = new String(pw);
        if(url == null || url.length() == 0)
        {
            status.setText("Please specify a database URL ");
            return;
        } // if(url == null || url.length() == 0)
        openConnection();
        password = null;                                // For security
        
        //--------------------------------------------------------------------
        // expand those which were expanded before
        //System.out.println("visibleTreePaths.length is : " + visibleTreePaths.length);
        
        for(int i = 0; i < visibleTreePaths.length; i++)
        {
            //dbTree.expandPath(visibleTreePaths[i]);
            //System.out.println(visibleTreePaths[i].toString());
            //dbTree.makeVisible(visibleTreePaths[i]);
            int row = getParentRowToExpand(visibleTreePaths[i]);
                     
            // might cause dead lock??
            if(row != -1)
            {
                if(!dbTree.isExpanded(row))
                    dbTree.expandRow(row);
                // Not all the rows will be expanded if the rows do not expand fast enough.
                // to be fixed later 06/12/2002
                //System.out.println("Row to expand: " + row);
                //System.out.println("Row expanded: " + dbTree.isExpanded(row));
                /*
                while(!dbTree.isExpanded(row))
                {
                    //dbTree.expandRow(row);
                    dbTree.expandRow(row);
                } // while(!dbTree.isExpanded(row))
                 */
            } // if(row != -1)            
        } // for(int i = 0; i < visibleTreePaths.length; i++)
        
        //dbTree.expandRow(1);
        //System.out.println("visibleTreePaths.length is : " + visibleTreePaths.length);
        
    } // public void refreshConnection()
    
    // use with current dbTree    
    public int getParentRowToExpand(TreePath treePath)
    {
        //(DefaultMutableTreeNode)treePath.getLastPathComponent();
        TreePath parentPath = treePath.getParentPath();
        if(parentPath == null)          // if there is no parent, we don't need to expand this path
            return -1;
        // we need to compare the entire path
        //Object parentUserObject = ((DefaultMutableTreeNode) parentPath.getLastPathComponent()).getUserObject();
        int parentRow = -1;         // -1 means currently not visible
        
        //TreePath[] visibleTreePaths = new TreePath[dbTree.getRowCount()];
        
        //System.out.println("Row Count: " + dbTree.getRowCount());
        //System.out.println("parentUserObject: " + parentUserObject);
        
        for(int i = 0; i < dbTree.getRowCount(); i++)
        {
            //System.out.println("visibleDBUserObject: " + ((DefaultMutableTreeNode) dbTree.getPathForRow(i).getLastPathComponent()).getUserObject());
            // Note: We only compare the strings of the Object, if they are the same, we will treat it as the row to expand
            //if(parentUserObject.toString().equals(((DefaultMutableTreeNode) dbTree.getPathForRow(i).getLastPathComponent()).getUserObject().toString()))
            // we need to compare the entire path
            if(parentPath.toString().equals(dbTree.getPathForRow(i).toString()))
            {
                //System.out.println("parentPath: " + parentPath.toString());
                //System.out.println("dbTree.getPathForRow("+ i + "): " + dbTree.getPathForRow(i).toString());
                //System.out.print("Row to expand: " + i);
                parentRow = i;
                break;
            } // if(parentUserObject.equals(((DefaultMutableTreeNode) dbTree.getPathForRow(i).getLastPathComponent()).getUserObject()))
        } // for(int i = 0; i < visibleTreePaths.length; i++)
        
        return parentRow;
    } //public int getParentRowToExpand(TreePath treePath)
    
    public void actionPerformed(ActionEvent e)
    {
        Object source = e.getSource();                      // Get source of the event
        if(source == serverIPInput ||                            // If it is serverIP input,
           source == serverPortInput ||                            // If it is serverPort input,
           source == usernameInput ||                         // or username input,
           source == passwordInput ||                            // or password input
           source == connectButton                            // or connectButton           
           )                        
        {                                                   // we will try for a connection
            //url = database.getText();                       // Get database URL
                        
            serverIP = serverIPInput.getText();
            serverPort = serverPortInput.getText();    
            
            url = PostgreSQLDataObject.getDefaultDBURL(serverIP, serverPort);
            username = usernameInput.getText();                 // Get user ID
            
            char[] pw = passwordInput.getPassword();        // Get password
            if(pw != null)
                password = new String(pw);
            
            if(url == null || url.length() == 0)
            {
                status.setText("Please specify a database URL ");
                return;
            } // if(url == null || url.length() == 0)
            openConnection();
            password = null;                                // For security
        } // if(source == database ||
        else if(source == refreshButton)                    // or refreshButton
        {
            refreshConnection();
        } // else if(source == refreshButton)
        
    } // public void actionPerformed(ActionEvent e)
    //dbTree.setS
    
    public void valueChanged(TreeSelectionEvent e)
    {
        TreePath[] paths = dbTree.getSelectionPaths();
        //int[] selectedRows = dbTree.getSelectionRows();
        if(paths == null)
            return;
        boolean tableSelected = false;              // Set true if a table is selected
        String column;                              // Stores a column name from a path
        String table;                               // Stores a table name from a path
        String columnsParam = null;                 // Column names in SQL SELECT
        String tableParam = null;                   // Table name in SQL SELECT
        String message = null;                      // Message for status area
        
        /*
        System.out.println("selectedRows.length is " + selectedRows.length);
        System.out.println("SelectionCount is " + dbTree.getSelectionCount());
        for(int i = 0; i < dbTree.getSelectionCount(); i++)
            System.out.println("selected row is " + selectedRows[i]);
        */
        /*
        for(int j = 0; j < paths.length; j++)
        {
            switch(paths[j].getPathCount())
            {
                case 2:                             // We have a table selected
                    tableParam = (String)(((DefaultMutableTreeNode)(paths[j].getPathComponent(1))).getUserObject());
                    columnsParam = "*";             // Select all columns
                    tableSelected = true;           // Set flag for a table selected
                    message = "Complete " + tableParam + " table displayed";
                    break;
                    
                case 3:                             // Column selected
                    table = (String)(((DefaultMutableTreeNode)(paths[j].getPathComponent(1))).getUserObject());
                    if(tableParam == null)
                        tableParam = table;
                    else if(tableParam != table)
                        break;
                    column = (String)(((DefaultMutableTreeNode)(paths[j].getPathComponent(2))).getUserObject());
                    if(columnsParam == null)        // If no previous columns
                        columnsParam = column;      // add the column
                    else                                // otherwise
                        columnsParam += "," + column;   // we need a comma too
                    message = columnsParam + " displayed from " + tableParam + " table.";
                    break;                    
            } // switch(paths[j].getPathCount())
            if(tableSelected)                       // If a table was selected
                break;                              // we are done
        } // for(int j = 0; j < paths.length; j++)
        
        try
        {
            // Display the columns and change the scroll pane border
            tableModel.setResultSet(statement.executeQuery("SELECT " + columnsParam + " FROM " + tableParam));
            infoPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), tableParam, TitledBorder.CENTER, TitledBorder.DEFAULT_POSITION));
        } // try
        catch(SQLException sqle)
        {
            message = "Selection event Error\n" + sqle.getMessage();
            System.err.println(message);
        } // catch(SQLException sqle)
         */
        if(message != null)
            status.setText(message);
    } // public void valueChanged(TreeSelectionEvent e)
    
    // to find out if the clicked nodes are the same.
    public boolean isHomogeneousNodeSelection(TreePath[] treePaths)
    {
        boolean isHomogeneous = true;
        //Object[] userObjects = new Objects[treePath.length];
        Object firstObject = ((DefaultMutableTreeNode) treePaths[0].getLastPathComponent()).getUserObject().getClass();
        for(int i = 1; i < treePaths.length; i++)
            if(!(firstObject.equals(((DefaultMutableTreeNode) treePaths[i].getLastPathComponent()).getUserObject().getClass())))
                isHomogeneous = false;
        //for(int i = 0; i < treePaths.length; i++)
            //System.out.println(((DefaultMutableTreeNode) treePaths[i].getLastPathComponent()).getUserObject().getClass());
        return isHomogeneous;
    } // public boolean isHomogeneousNode()
   
    /*
    public JPopupMenu getPopup()
    {
        return defaultPanelPopup;
    } // public JPopupMenu getPopup()
     */
    
    public void treeSingleClick(int row, TreePath path)
    {
        ;
    } // public void treeSingleClick(int row, TreePath path)
    
    public void treeDoubleClick(int row, TreePath path)
    {
        ;
    } // public void treeDoubleClick(int row, TreePath path)
    
    public void treeSingleSelect(int row, TreePath path)
    {
        //System.out.println(Locale.getDefault().getLanguage());
        // "<HTML><H1><FONT color=\"ff0000\">Test! </FONT></H1><A href=\"http://www.ximnet.com\">link</A></HTML>"
        //editorPane.setText("<HTML><IMG SRC=\""+ urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/viewnode.gif") +"\"></IMG><H1><FONT color=ff0000>Test! </FONT></H1><A href=\"http://www.ximnet.com\">link</A>졪</HTML>");
        //System.out.println(urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/viewnode.gif"));
        //editorPane.setText("<HTML><H1><FONT color=\"ff0000\">Test! </FONT></H1><A href=\"http://www.ximnet.com\">link</A></HTML>");
        
        String htmlStr = PostgreSQLDataObject.getNodePropertyInHTML(this, dbTree);
        
        if(htmlStr != null)
            editorPane.setText(htmlStr);
        
    } // public void treeSelect(int row, TreePath path)
    
    public void treePopupTrigger(int row, Component comp, int x, int y)
    {
        int[] selectedRows = dbTree.getSelectionRows();
        boolean rowSelected = false;
        JPopupMenu popup = new JPopupMenu();
        //--------------------------------------------------------------------
        // select current row only if it has not been selected
        if(row != -1)
        {
            
            if((selectedRows != null))
            {
                //System.out.println("some rows selected");
                for(int i = 0; i < selectedRows.length; i++)
                    if(selectedRows[i] == row)
                    {
                        rowSelected = true;
                        //System.out.println("Already selected row: " + row);
                    } // if(selectedRows[i] == row)
                if(!rowSelected)
                {
                    dbTree.setSelectionRow(row);
                    //System.out.println("Selected row: " + row);
                } // if(!rowSelected)
                //----------------------------------------------------------------
                // process all selected rows
            } // if((selectedRows != null))
            else
                dbTree.setSelectionRow(row);
            
            int[] newSelectedRows = dbTree.getSelectionRows();
            
            if(newSelectedRows.length == 1)     // only one row selected
            {
                TreePath treePath = dbTree.getPathForRow(row);
                Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                NodeObject nodeObject;
                if(userObject instanceof String)
                    defaultPanelPopup.show(comp, x, y);
                else
                {
                    String[] actionList;
                
                    nodeObject = (NodeObject) userObject;
                    actionList = PostgreSQLDataObject.getPopupMenuNodeActionList(nodeObject);
                    for(int i = 0; i < actionList.length; i++)
                    {
                        if(actionList[i].equals("JSeparator"))
                            popup.add(new JSeparator());
                        else
                            popup.add(new GenericAction(actionList[i]));
                    } // for(int i = 0; i < actionList.length; i++)
                        
                    
                    popup.show(comp, x, y);                        
                } // else                
                //----------------------------------------------------------------
            } // if(newSelectedRows.length == 1)
            else
            {
                if(isHomogeneousNodeSelection(dbTree.getSelectionPaths()))
                {
                    TreePath treePath = dbTree.getPathForRow(row);
                    Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    NodeObject nodeObject;
                    if(userObject instanceof String)
                        defaultPanelPopup.show(comp, x, y);
                    else
                    {
                        String[] actionList;
                
                        nodeObject = (NodeObject) userObject;
                        actionList = PostgreSQLDataObject.getPopupMenuMultipleNodeActionList(nodeObject);
                        for(int i = 0; i < actionList.length; i++)
                        {
                            if(actionList[i].equals("JSeparator"))
                                popup.add(new JSeparator());
                            else
                                popup.add(new GenericAction(actionList[i]));
                        } // for(int i = 0; i < actionList.length; i++)
                    
                        popup.show(comp, x, y);                        
                    } // else                
                //----------------------------------------------------------------
                } // if(isHomogeneous(dbTree.getSelectionPaths()))
                else
                    defaultPanelPopup.show(comp, x, y);             // maybe changed to accomodate selection among multiple node types
            } // else            
        } // if(row != -1)
        else 
            defaultPanelPopup.show(comp, x, y);
    } // public void treePopupTrigger(int row, TreePath path)
    
    public String getContentsStringFromFile(String url, String language)
    {
        BufferedReader buffReader;
        String fileContentsStr = "";
        String thisLine;
        try
        {  
            if(language.equals("ja"))
            {
                buffReader = new BufferedReader(new InputStreamReader(urlClassLoader.getResource(url).openStream(), "JISAutoDetect"));
            } // if(language.equals("ja"))
            else
                buffReader = new BufferedReader(new InputStreamReader(urlClassLoader.getResource(url).openStream()));
            if(buffReader.ready())
            {
                while((thisLine = buffReader.readLine()) != null)
                {
                    fileContentsStr = fileContentsStr + thisLine + "\n";
                } // while((thisLine = buffReader.readLine()) != null)
            } // if(buffReader.read())
        } // try
        catch(IOException ioe)
        {
            ;
        } // catch(IOException ioe)
        return fileContentsStr;
    } // public String getContentsStringFromFile(String url)
       
    class TreeMouseHandler extends MouseAdapter
    {
        private Point start;
        
        public void mousePressed(MouseEvent e) {
            int selRow = dbTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = dbTree.getPathForLocation(e.getX(), e.getY());
            if(e.isPopupTrigger())
            //if((modifier & e.BUTTON3_MASK) != 0)
            {
                start = e.getPoint();
                //theApp.getWindow().getPopup().show((Component) e.getSource(), start.x, start.y);
                treePopupTrigger(selRow, (Component) e.getSource(), start.x, start.y);
                
                start = null;
            } // if(e.isPopupTrigger())
            else if(selRow != -1) {
                if(e.getClickCount() == 1) {
                    treeSingleClick(selRow, selPath);
                }
                else if(e.getClickCount() == 2) {
                    treeDoubleClick(selRow, selPath);
                }
            }
            /*
            if(selRow != -1)
            {
                treeSelect(selRow, selPath);
            } // if(selRow != -1)
             */
        } // public void mousePressed(MouseEvent e) {
        
        public void mouseReleased(MouseEvent e)
        {
            int modifier = e.getModifiers();
            
            if(e.isPopupTrigger())
            //if((modifier & e.BUTTON3_MASK) != 0)
            {
                start = e.getPoint();
                int selRow = dbTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = dbTree.getPathForLocation(e.getX(), e.getY());
                //theApp.getWindow().getPopup().show((Component) e.getSource(), start.x, start.y);
                treePopupTrigger(selRow, (Component) e.getSource(), start.x, start.y);
                
                start = null;
            } // if(e.isPopupTrigger())
        } // public void mouseReleased(MouseEvent e)


    } // class TreeMouseListener extends MouseAdapter
    
//---------------------------------------------------------------------------
// Inner Classes for database actions
    class GenericAction extends AbstractAction
    {
        String name;
        String actionType;
        
        public GenericAction(String name, String actionType)
        {  
            super(name);
            this.name = name;
            this.actionType = actionType;
        } // public DatabaseAction(String name)
        
        public GenericAction(String name)
        {
            this(name, null);
        } // public GenericAction(String name)
        
        public String getName()
        {
            return name;
        } // public String getName()

        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            //if(actionType == null)
            //    System.out.println("No action or null action");
            PostgreSQLDataObject.performAction((Component) actionEvent.getSource(), name, dbTree, refreshListener);
            // short-cut, just refresh after every action.
            //refreshConnection();
        }
        
    } // class GenericAction extends AbstractAction
    
    
    class RefreshAction extends AbstractAction
    {
    public void actionPerformed(java.awt.event.ActionEvent actionEvent)
        {
            refreshConnection();
        } // public void actionPerformed(java.awt.event.ActionEvent actionEvent)        
    } // class GenericAction extends AbstractAction
//---------------------------------------------------------------------------
    
    class TreeSelectionHandler implements TreeSelectionListener
    {
        
        public void valueChanged(TreeSelectionEvent e)
        {
            int[] selRows = dbTree.getSelectionRows();
            
            if(isDBTreeLoaded)
            {
                if(selRows != null)
                {
                    if(selRows.length == 1)                 // only one row is selected
                    {
                        treeSingleSelect(selRows[0], dbTree.getSelectionPath());
                        //System.out.println("List Selected");
                    } // if(selRows.length == 1)
                    else
                        editorPane.setText("");               // clear the infoPane
                        //infoPane.removeAll();               // clear the editorPane
                } // if(selRows != null)
            } // if(isDBTreeLoaded)
        } // public void valueChanged(TreeSelectionEvent e)
        
    } // class TreeSelectionHandler implements TreeSelectionListener
    
    class HyperlinkHandler implements HyperlinkListener
    {
        /*        
        public HyperlinkHandler()
        {
            webBrowser = new BrowserLauncher();
        } // public HyperlinkHandler()
         */
        
        public void hyperlinkUpdate(HyperlinkEvent e)
        {
            if(e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED))
            {
                //System.out.println(e.getURL().getProtocol());
                // Do nothing if we don't know the protocol
                if(e.getURL() == null)
                    return;
                if(e.getURL().getProtocol().equals("http"))
                {
                    try
                    {
                        BrowserLauncher.openURL(e.getURL().toString());
                    } // try
                    catch(IOException ioe)
                    {
                        System.out.println("Cannot Launch Browser: " + ioe.getMessage());
                    } // catch(IOException ioe)
                } // if(e.getURL().getProtocol().equals("http"))
            } // if(e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED))
            
        } // public void hyperlinkUpdate(HyperlinkEvent e)
        
    }
    
    class GenericMouseHandler extends MouseAdapter {
        
        public void mousePressed(MouseEvent e) {
            if(e.isPopupTrigger())
                popupTrigger((Component) e.getSource(), e.getX(), e.getY());
        }
        
        public void mouseReleased(MouseEvent e) {
            if(e.isPopupTrigger())
                popupTrigger((Component) e.getSource(), e.getX(), e.getY());
        }
        
        public void popupTrigger(Component comp, int x, int y) {
            defaultPanelPopup.show(comp, x, y);
        }
        
    }
    
 // class HyperlinkHandler implements HyperlinkListener
        
} // class DatabaseBrowse extends JFrame