package org.nihonsoft.turbosql.modules.pg.app;

import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;
import java.sql.*;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class TestTree extends JFrame
{
    //private String[] drivers = {"org.postgresql.Driver"};   // postgresql driver
    private String username = "postgres";
    private String password = "pg.test";
       
    private String serverIP = "192.168.168.235";
    private String serverPort = "5432";
    //private String databaseDef = "template1";
    private Connection conn;
    
    // temp
    //private String url = "jdbc:postgresql://192.168.168.235:5432/template1";
    private String url = "";
    
    public TestTree(String name)
    {
        super(name);
        this.setDefaultCloseOperation(this.DISPOSE_ON_CLOSE);
        this.setBounds(10, 10, 300, 300);
        this.setVisible(true);
        
        DefaultMutableTreeNode serverNode = new DefaultMutableTreeNode("No database");
        DefaultTreeModel dbTreeModel = new DefaultTreeModel(serverNode);
        JTree dbTree = new JTree(dbTreeModel);
        JScrollPane treePane = new JScrollPane(dbTree);
        treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        //treePane.setHorizontalScrollBarPolicy(treePane.HORIZONTAL_SCROLLBAR_ALWAYS);
        this.getContentPane().add(treePane);
        
        DefaultMutableTreeNode dbNode = new DefaultMutableTreeNode("Database 1");
        
        serverNode.setUserObject("Server 1");
        serverNode.add(dbNode);
        
        dbTreeModel.setRoot(dbNode);
        
        serverNode = new DefaultMutableTreeNode(new ServerNodeObject(serverIP, username, password, serverIP, serverPort));
        
        /*
        for(int i = 0; i < drivers.length; i++)
            try
            {
                Class.forName(drivers[i]);
            }
            catch(ClassNotFoundException cnfe)
            {
                System.err.println(cnfe);
                //status.setText("Driver load failed: " + cnfe.getMessage());
            } // catch(ClassNotFoundException cnfe)
        
        try
        {
            conn = DriverManager.getConnection(url, username, password);
        } // try
        catch(SQLException sqle)    
        {
            System.out.println(sqle.getMessage());
        } // catch(SQLException sqle)
         */
        
        dbTree.setCellRenderer(new DBTreeCellRenderer());
        
        url = PostgreSQLDataObject.getDefaultDBURL(serverIP, serverPort);
        
        conn = PostgreSQLDataObject.getConnection(url, username, password);
        
        PostgreSQLDataObject.buildServerNode(serverNode, conn);
        
        dbTreeModel.setRoot(serverNode);
        
        //pack();
        show();
        
    } // public TestTree()
    
    public static void main(String[] args)
    {
        TestTree tTree = new TestTree("Test Tree");
        //JDialog jDialog = new JDialog(this, "test");
        //JOptionPane.showMessageDialog(tTree, "test");
    } // public static void main(String[] args)
} // public class TestTree extends JFrame
