package org.nihonsoft.turbosql.modules.pg.app.dialogs;

import javax.swing.*;
import javax.swing.JOptionPane;
import javax.swing.JDialog;
import javax.swing.JTextField;
import java.beans.*; //Property change stuff
import java.awt.*;
import java.awt.event.*;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

class PromptDialog extends JDialog
{
    private String typedText = null;
    private String theQuestion = null;

    private JOptionPane optionPane;

    public String getValidatedText() {
        return typedText;
    }

    public PromptDialog(Frame aFrame, String theQuestion)
    {
        super(aFrame, true);
        
        this.theQuestion = theQuestion;
        
        setTitle("Prompt");

        final JTextField textField = new JTextField(10);
        Object[] array = {theQuestion, textField};

        final String btnString1 = "Ok";
        final String btnString2 = "Cancel";
        Object[] options = {btnString1, btnString2};

        optionPane = new JOptionPane(array, 
                                    JOptionPane.QUESTION_MESSAGE,
                                    JOptionPane.YES_NO_OPTION,
                                    null,
                                    options,
                                    options[0]);
        setContentPane(optionPane);
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent we) {
                /*
                 * Instead of directly closing the window,
                 * we're going to change the JOptionPane's
                 * value property.
                 */
                    optionPane.setValue(new Integer(
                                        JOptionPane.CLOSED_OPTION));
            }
        });

        textField.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(btnString1);
            }
        });

        optionPane.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();

                if (isVisible() 
                 && (e.getSource() == optionPane)
                 && (prop.equals(JOptionPane.VALUE_PROPERTY) ||
                     prop.equals(JOptionPane.INPUT_VALUE_PROPERTY))) {
                    Object value = optionPane.getValue();

                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        //ignore reset
                        return;
                    }

                    // Reset the JOptionPane's value.
                    // If you don't do this, then if the user
                    // presses the same button next time, no
                    // property change event will be fired.
                    optionPane.setValue(
                            JOptionPane.UNINITIALIZED_VALUE);

                    /*
                    if (value.equals(btnString1)) {
                            typedText = textField.getText();
                        String ucText = typedText.toUpperCase();
                        if (ucText.equals(magicWord)) {
                            // we're done; dismiss the dialog
                            setVisible(false);
                        } else { 
                            // text was invalid
                            textField.selectAll();
                            JOptionPane.showMessageDialog(
                                            CustomDialog.this,
                                            "Sorry, \"" + typedText + "\" "
                                            + "isn't a valid response.\n"
                                            + "Please enter " 
                                            + magicWord + ".",
                                            "Try again",
                                            JOptionPane.ERROR_MESSAGE);
                            typedText = null;
                        }
                    } else { // user closed dialog or clicked cancel
                        dd.setLabel("It's OK.  "
                                 + "We won't force you to type "
                                 + magicWord + ".");
                        typedText = null;
                        setVisible(false);
                    }
                     */
                }
            }
        });
    }
    
    public static void main(String args[])
    {
        JFrame jFrame = new JFrame("test");
        jFrame.setBounds(0, 0, 100, 100);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        //DatabaseAddPane pane = new DatabaseAddPane("192.168.168.235", "5432", "postgres", "pg.test");
        PromptDialog jDialog = new PromptDialog(jFrame, "test question?");
        //dialog.setVisible(true);
        jDialog.show();
    } // public static void main(String args[])
    
} // class TableNameGetterDialog extends JDialog