package org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer;

import javax.swing.JInternalFrame;
import javax.swing.JDesktopPane;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class ConsoleFrame extends JFrame
{
    JDesktopPane desktop;
    public ConsoleFrame()
    {
        super("Database Browser");
        
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds(inset, inset, 
                  screenSize.width - inset*2, 
                  screenSize.height-inset*2);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        addWindowListener(new WindowHandler());
        
        desktop = new JDesktopPane(); //a specialized layered pane
        //createFrame(); //Create first window
        setContentPane(desktop);
        //setJMenuBar(createMenuBar());

        //Make dragging faster:
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
        
        
        //pack();                                 // layout the components at their appropriate sizes
        
        setVisible(true);                       // Set window visible
        show();
        
        /*
        SQLAnalyzerWindow window = new SQLAnalyzerWindow();
        window.setBounds(inset, inset, 
                  screenSize.width - inset*2, 
                  screenSize.height-inset*2);
        //window.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        window.addWindowListener(new WindowHandler());
        window.setVisible(true);
        window.show();
         */
        
        String driver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://127.0.0.1:5432/testpg";
        String user = "postgres";
        String password = "";
        String dataTypeMapper = "PostgreSQLDataTypeMapper";             // PostgreSQL-to-Java DataType mapping.
        
        InteractiveSQL theApp = new InteractiveSQL(driver, url, user, password, dataTypeMapper);
        
    } // public ConsolseFrame()
    
    public static void main(String[] args)
    {
        ConsoleFrame frame = new ConsoleFrame();
    } // public static void main(String[] args)
    
    // Inner class defining handler for window events
    class WindowHandler extends WindowAdapter
    {
        // Handler for window closing event
        public void windowClosing(WindowEvent e)
        {
            dispose();                          // Release the window resources
            System.exit(0);                     // End the application
        } // public void windowClosing(WindowEvent e)
        
    } // class WindowHandler extends WindowAdapter
    
} // public class ConsoleFrame extends Frame


