/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import uk.org.retep.app.Constants;
import uk.org.retep.app.Desktop;
import uk.org.retep.swing.ExceptionDialog;
import uk.org.retep.tools.ToolManager;
import uk.org.retep.xml.core.XML;
import uk.org.retep.xml.core.XMLUtils;
import uk.org.retep.xml.core.XMLWriter;

public class Workspace
implements XML {
    private static Workspace SINGLETON = new Workspace();
    private Hashtable props = new Hashtable();
    private Properties def = new Properties();
    private boolean modified;
    private File file = Constants.DEFAULT_WORKSPACE;

    public static Workspace getInstance() {
        return SINGLETON;
    }

    private Workspace() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("Workspace.properties");
            this.def.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            ExceptionDialog.show(iOException);
        }
        this.props = new Properties(this.def);
    }

    public void set(Object object, Object object2) {
        this.props.put(object, object2);
    }

    public Object get(Object object) {
        Object v = this.props.get(object);
        if (v == null) {
            v = ((Hashtable)this.def).get(object);
        }
        return v;
    }

    public Object get(Object object, Object object2) {
        Object v = this.props.get(object);
        if (v == null) {
            return object2;
        }
        return v;
    }

    public Iterator getProperties() {
        return this.props.keySet().iterator();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void openWorkspace(File file, boolean bl) {
        block3: {
            Workspace.getInstance().setFile(file);
            try {
                Workspace.decodeXML(XMLUtils.parseXML(new FileInputStream(file)));
            }
            catch (SAXException sAXException) {
                ExceptionDialog.show(sAXException);
            }
            catch (IOException iOException) {
                if (bl) break block3;
                ExceptionDialog.show(iOException);
            }
        }
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXML(xMLWriter, "WORKSPACE");
    }

    public void writeXML(XMLWriter xMLWriter, String string) {
        xMLWriter.startTag(string);
        xMLWriter.addAttribute("VERSION", "0.1");
        if (Desktop.getInstance() != null) {
            xMLWriter.startTag("GEOMETRY");
            XMLUtils.saveState(xMLWriter, Desktop.getInstance());
            xMLWriter.closeTag();
        }
        if (this.props.size() > 0) {
            xMLWriter.startTag("PROPERTIES");
            XMLUtils.writeXML(xMLWriter, this.props);
            xMLWriter.closeTag();
        }
        ToolManager.getInstance().writeXML(xMLWriter);
        xMLWriter.closeTag();
        this.setModified(false);
    }

    public static Workspace decodeXML(Element element) throws SAXException {
        Object object;
        Object object2;
        Workspace workspace = Workspace.getInstance();
        ToolManager toolManager = ToolManager.getInstance();
        if (Desktop.getInstance() != null) {
            object2 = toolManager.getTools();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                Iterator iterator = toolManager.getToolData(string);
                while (iterator.hasNext()) {
                    object = toolManager.getToolData(string, (String)iterator.next());
                    if (object.getTool() != null) {
                        object.getTool().closeTool();
                    }
                    iterator.remove();
                }
            }
        }
        workspace.props.clear();
        object2 = element.getChildNodes();
        int n = 0;
        int n2 = object2.getLength();
        while (n < n2) {
            object = object2.item(n);
            String string = object.getNodeName();
            if (object.getNodeType() == 1) {
                if ("GEOMETRY".equals(string)) {
                    Desktop desktop = Desktop.getInstance();
                    if (desktop != null) {
                        XMLUtils.restoreState((Element)object, desktop);
                    }
                } else if ("PROPERTIES".equals(string)) {
                    XMLUtils.decodeMap((Element)object, workspace.props);
                } else if ("TOOLS".equals(string)) {
                    ToolManager.decodeXML((Element)object);
                }
            }
            ++n;
        }
        return workspace;
    }
}

